# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use openshift.client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a openshift.client. By listing and beginning a watch from the returned resourceVersion, openshift.clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so openshift.clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but openshift.clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: v1.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import openshift.client
from kubernetes.client.rest import ApiException
from openshift.client.apis.oapi_api import OapiApi


class TestOapiApi(unittest.TestCase):
    """ OapiApi unit test stubs """

    def setUp(self):
        self.api = openshift.client.apis.oapi_api.OapiApi()

    def tearDown(self):
        pass

    def test_connect_post_namespaced_binary_build_request_options_instantiatebinary(self):
        """
        Test case for connect_post_namespaced_binary_build_request_options_instantiatebinary

        
        """
        pass

    def test_connect_post_namespaced_status_webhooks(self):
        """
        Test case for connect_post_namespaced_status_webhooks

        
        """
        pass

    def test_connect_post_namespaced_status_webhooks_with_path(self):
        """
        Test case for connect_post_namespaced_status_webhooks_with_path

        
        """
        pass

    def test_create_build_config_for_all_namespaces(self):
        """
        Test case for create_build_config_for_all_namespaces

        
        """
        pass

    def test_create_build_for_all_namespaces(self):
        """
        Test case for create_build_for_all_namespaces

        
        """
        pass

    def test_create_cluster_network(self):
        """
        Test case for create_cluster_network

        
        """
        pass

    def test_create_cluster_policy(self):
        """
        Test case for create_cluster_policy

        
        """
        pass

    def test_create_cluster_policy_binding(self):
        """
        Test case for create_cluster_policy_binding

        
        """
        pass

    def test_create_cluster_resource_quota(self):
        """
        Test case for create_cluster_resource_quota

        
        """
        pass

    def test_create_cluster_role(self):
        """
        Test case for create_cluster_role

        
        """
        pass

    def test_create_cluster_role_binding(self):
        """
        Test case for create_cluster_role_binding

        
        """
        pass

    def test_create_deployment_config_for_all_namespaces(self):
        """
        Test case for create_deployment_config_for_all_namespaces

        
        """
        pass

    def test_create_deployment_config_rollback_for_all_namespaces(self):
        """
        Test case for create_deployment_config_rollback_for_all_namespaces

        
        """
        pass

    def test_create_egress_network_policy_for_all_namespaces(self):
        """
        Test case for create_egress_network_policy_for_all_namespaces

        
        """
        pass

    def test_create_group(self):
        """
        Test case for create_group

        
        """
        pass

    def test_create_host_subnet(self):
        """
        Test case for create_host_subnet

        
        """
        pass

    def test_create_identity(self):
        """
        Test case for create_identity

        
        """
        pass

    def test_create_image(self):
        """
        Test case for create_image

        
        """
        pass

    def test_create_image_signature(self):
        """
        Test case for create_image_signature

        
        """
        pass

    def test_create_image_stream_for_all_namespaces(self):
        """
        Test case for create_image_stream_for_all_namespaces

        
        """
        pass

    def test_create_image_stream_import_for_all_namespaces(self):
        """
        Test case for create_image_stream_import_for_all_namespaces

        
        """
        pass

    def test_create_image_stream_mapping_for_all_namespaces(self):
        """
        Test case for create_image_stream_mapping_for_all_namespaces

        
        """
        pass

    def test_create_image_stream_tag_for_all_namespaces(self):
        """
        Test case for create_image_stream_tag_for_all_namespaces

        
        """
        pass

    def test_create_local_resource_access_review_for_all_namespaces(self):
        """
        Test case for create_local_resource_access_review_for_all_namespaces

        
        """
        pass

    def test_create_local_subject_access_review_for_all_namespaces(self):
        """
        Test case for create_local_subject_access_review_for_all_namespaces

        
        """
        pass

    def test_create_namespaced_build(self):
        """
        Test case for create_namespaced_build

        
        """
        pass

    def test_create_namespaced_build_config(self):
        """
        Test case for create_namespaced_build_config

        
        """
        pass

    def test_create_namespaced_build_request_clone(self):
        """
        Test case for create_namespaced_build_request_clone

        
        """
        pass

    def test_create_namespaced_build_request_instantiate(self):
        """
        Test case for create_namespaced_build_request_instantiate

        
        """
        pass

    def test_create_namespaced_deployment_config(self):
        """
        Test case for create_namespaced_deployment_config

        
        """
        pass

    def test_create_namespaced_deployment_config_rollback(self):
        """
        Test case for create_namespaced_deployment_config_rollback

        
        """
        pass

    def test_create_namespaced_deployment_config_rollback_rollback(self):
        """
        Test case for create_namespaced_deployment_config_rollback_rollback

        
        """
        pass

    def test_create_namespaced_deployment_request_instantiate(self):
        """
        Test case for create_namespaced_deployment_request_instantiate

        
        """
        pass

    def test_create_namespaced_egress_network_policy(self):
        """
        Test case for create_namespaced_egress_network_policy

        
        """
        pass

    def test_create_namespaced_image_stream(self):
        """
        Test case for create_namespaced_image_stream

        
        """
        pass

    def test_create_namespaced_image_stream_import(self):
        """
        Test case for create_namespaced_image_stream_import

        
        """
        pass

    def test_create_namespaced_image_stream_mapping(self):
        """
        Test case for create_namespaced_image_stream_mapping

        
        """
        pass

    def test_create_namespaced_image_stream_tag(self):
        """
        Test case for create_namespaced_image_stream_tag

        
        """
        pass

    def test_create_namespaced_local_resource_access_review(self):
        """
        Test case for create_namespaced_local_resource_access_review

        
        """
        pass

    def test_create_namespaced_local_subject_access_review(self):
        """
        Test case for create_namespaced_local_subject_access_review

        
        """
        pass

    def test_create_namespaced_pod_security_policy_review(self):
        """
        Test case for create_namespaced_pod_security_policy_review

        
        """
        pass

    def test_create_namespaced_pod_security_policy_self_subject_review(self):
        """
        Test case for create_namespaced_pod_security_policy_self_subject_review

        
        """
        pass

    def test_create_namespaced_pod_security_policy_subject_review(self):
        """
        Test case for create_namespaced_pod_security_policy_subject_review

        
        """
        pass

    def test_create_namespaced_policy(self):
        """
        Test case for create_namespaced_policy

        
        """
        pass

    def test_create_namespaced_policy_binding(self):
        """
        Test case for create_namespaced_policy_binding

        
        """
        pass

    def test_create_namespaced_processed_template(self):
        """
        Test case for create_namespaced_processed_template

        
        """
        pass

    def test_create_namespaced_resource_access_review(self):
        """
        Test case for create_namespaced_resource_access_review

        
        """
        pass

    def test_create_namespaced_role(self):
        """
        Test case for create_namespaced_role

        
        """
        pass

    def test_create_namespaced_role_binding(self):
        """
        Test case for create_namespaced_role_binding

        
        """
        pass

    def test_create_namespaced_role_binding_restriction(self):
        """
        Test case for create_namespaced_role_binding_restriction

        
        """
        pass

    def test_create_namespaced_route(self):
        """
        Test case for create_namespaced_route

        
        """
        pass

    def test_create_namespaced_self_subject_rules_review(self):
        """
        Test case for create_namespaced_self_subject_rules_review

        
        """
        pass

    def test_create_namespaced_subject_access_review(self):
        """
        Test case for create_namespaced_subject_access_review

        
        """
        pass

    def test_create_namespaced_subject_rules_review(self):
        """
        Test case for create_namespaced_subject_rules_review

        
        """
        pass

    def test_create_namespaced_template(self):
        """
        Test case for create_namespaced_template

        
        """
        pass

    def test_create_net_namespace(self):
        """
        Test case for create_net_namespace

        
        """
        pass

    def test_create_o_auth_access_token(self):
        """
        Test case for create_o_auth_access_token

        
        """
        pass

    def test_create_o_auth_authorize_token(self):
        """
        Test case for create_o_auth_authorize_token

        
        """
        pass

    def test_create_o_auth_client(self):
        """
        Test case for create_o_auth_client

        
        """
        pass

    def test_create_o_auth_client_authorization(self):
        """
        Test case for create_o_auth_client_authorization

        
        """
        pass

    def test_create_pod_security_policy_review_for_all_namespaces(self):
        """
        Test case for create_pod_security_policy_review_for_all_namespaces

        
        """
        pass

    def test_create_pod_security_policy_self_subject_review_for_all_namespaces(self):
        """
        Test case for create_pod_security_policy_self_subject_review_for_all_namespaces

        
        """
        pass

    def test_create_pod_security_policy_subject_review_for_all_namespaces(self):
        """
        Test case for create_pod_security_policy_subject_review_for_all_namespaces

        
        """
        pass

    def test_create_policy_binding_for_all_namespaces(self):
        """
        Test case for create_policy_binding_for_all_namespaces

        
        """
        pass

    def test_create_policy_for_all_namespaces(self):
        """
        Test case for create_policy_for_all_namespaces

        
        """
        pass

    def test_create_processed_template_for_all_namespaces(self):
        """
        Test case for create_processed_template_for_all_namespaces

        
        """
        pass

    def test_create_project(self):
        """
        Test case for create_project

        
        """
        pass

    def test_create_project_request(self):
        """
        Test case for create_project_request

        
        """
        pass

    def test_create_resource_access_review_for_all_namespaces(self):
        """
        Test case for create_resource_access_review_for_all_namespaces

        
        """
        pass

    def test_create_role_binding_for_all_namespaces(self):
        """
        Test case for create_role_binding_for_all_namespaces

        
        """
        pass

    def test_create_role_binding_restriction_for_all_namespaces(self):
        """
        Test case for create_role_binding_restriction_for_all_namespaces

        
        """
        pass

    def test_create_role_for_all_namespaces(self):
        """
        Test case for create_role_for_all_namespaces

        
        """
        pass

    def test_create_route_for_all_namespaces(self):
        """
        Test case for create_route_for_all_namespaces

        
        """
        pass

    def test_create_self_subject_rules_review_for_all_namespaces(self):
        """
        Test case for create_self_subject_rules_review_for_all_namespaces

        
        """
        pass

    def test_create_subject_access_review_for_all_namespaces(self):
        """
        Test case for create_subject_access_review_for_all_namespaces

        
        """
        pass

    def test_create_subject_rules_review_for_all_namespaces(self):
        """
        Test case for create_subject_rules_review_for_all_namespaces

        
        """
        pass

    def test_create_template_for_all_namespaces(self):
        """
        Test case for create_template_for_all_namespaces

        
        """
        pass

    def test_create_user(self):
        """
        Test case for create_user

        
        """
        pass

    def test_create_user_identity_mapping(self):
        """
        Test case for create_user_identity_mapping

        
        """
        pass

    def test_delete_cluster_network(self):
        """
        Test case for delete_cluster_network

        
        """
        pass

    def test_delete_cluster_policy(self):
        """
        Test case for delete_cluster_policy

        
        """
        pass

    def test_delete_cluster_policy_binding(self):
        """
        Test case for delete_cluster_policy_binding

        
        """
        pass

    def test_delete_cluster_resource_quota(self):
        """
        Test case for delete_cluster_resource_quota

        
        """
        pass

    def test_delete_cluster_role(self):
        """
        Test case for delete_cluster_role

        
        """
        pass

    def test_delete_cluster_role_binding(self):
        """
        Test case for delete_cluster_role_binding

        
        """
        pass

    def test_delete_collection_cluster_network(self):
        """
        Test case for delete_collection_cluster_network

        
        """
        pass

    def test_delete_collection_cluster_policy(self):
        """
        Test case for delete_collection_cluster_policy

        
        """
        pass

    def test_delete_collection_cluster_policy_binding(self):
        """
        Test case for delete_collection_cluster_policy_binding

        
        """
        pass

    def test_delete_collection_cluster_resource_quota(self):
        """
        Test case for delete_collection_cluster_resource_quota

        
        """
        pass

    def test_delete_collection_group(self):
        """
        Test case for delete_collection_group

        
        """
        pass

    def test_delete_collection_host_subnet(self):
        """
        Test case for delete_collection_host_subnet

        
        """
        pass

    def test_delete_collection_identity(self):
        """
        Test case for delete_collection_identity

        
        """
        pass

    def test_delete_collection_image(self):
        """
        Test case for delete_collection_image

        
        """
        pass

    def test_delete_collection_namespaced_build(self):
        """
        Test case for delete_collection_namespaced_build

        
        """
        pass

    def test_delete_collection_namespaced_build_config(self):
        """
        Test case for delete_collection_namespaced_build_config

        
        """
        pass

    def test_delete_collection_namespaced_deployment_config(self):
        """
        Test case for delete_collection_namespaced_deployment_config

        
        """
        pass

    def test_delete_collection_namespaced_egress_network_policy(self):
        """
        Test case for delete_collection_namespaced_egress_network_policy

        
        """
        pass

    def test_delete_collection_namespaced_image_stream(self):
        """
        Test case for delete_collection_namespaced_image_stream

        
        """
        pass

    def test_delete_collection_namespaced_policy(self):
        """
        Test case for delete_collection_namespaced_policy

        
        """
        pass

    def test_delete_collection_namespaced_policy_binding(self):
        """
        Test case for delete_collection_namespaced_policy_binding

        
        """
        pass

    def test_delete_collection_namespaced_role_binding_restriction(self):
        """
        Test case for delete_collection_namespaced_role_binding_restriction

        
        """
        pass

    def test_delete_collection_namespaced_route(self):
        """
        Test case for delete_collection_namespaced_route

        
        """
        pass

    def test_delete_collection_namespaced_template(self):
        """
        Test case for delete_collection_namespaced_template

        
        """
        pass

    def test_delete_collection_net_namespace(self):
        """
        Test case for delete_collection_net_namespace

        
        """
        pass

    def test_delete_collection_o_auth_access_token(self):
        """
        Test case for delete_collection_o_auth_access_token

        
        """
        pass

    def test_delete_collection_o_auth_authorize_token(self):
        """
        Test case for delete_collection_o_auth_authorize_token

        
        """
        pass

    def test_delete_collection_o_auth_client(self):
        """
        Test case for delete_collection_o_auth_client

        
        """
        pass

    def test_delete_collection_o_auth_client_authorization(self):
        """
        Test case for delete_collection_o_auth_client_authorization

        
        """
        pass

    def test_delete_collection_user(self):
        """
        Test case for delete_collection_user

        
        """
        pass

    def test_delete_group(self):
        """
        Test case for delete_group

        
        """
        pass

    def test_delete_host_subnet(self):
        """
        Test case for delete_host_subnet

        
        """
        pass

    def test_delete_identity(self):
        """
        Test case for delete_identity

        
        """
        pass

    def test_delete_image(self):
        """
        Test case for delete_image

        
        """
        pass

    def test_delete_image_signature(self):
        """
        Test case for delete_image_signature

        
        """
        pass

    def test_delete_namespaced_build(self):
        """
        Test case for delete_namespaced_build

        
        """
        pass

    def test_delete_namespaced_build_config(self):
        """
        Test case for delete_namespaced_build_config

        
        """
        pass

    def test_delete_namespaced_deployment_config(self):
        """
        Test case for delete_namespaced_deployment_config

        
        """
        pass

    def test_delete_namespaced_egress_network_policy(self):
        """
        Test case for delete_namespaced_egress_network_policy

        
        """
        pass

    def test_delete_namespaced_image_stream(self):
        """
        Test case for delete_namespaced_image_stream

        
        """
        pass

    def test_delete_namespaced_image_stream_tag(self):
        """
        Test case for delete_namespaced_image_stream_tag

        
        """
        pass

    def test_delete_namespaced_policy(self):
        """
        Test case for delete_namespaced_policy

        
        """
        pass

    def test_delete_namespaced_policy_binding(self):
        """
        Test case for delete_namespaced_policy_binding

        
        """
        pass

    def test_delete_namespaced_role(self):
        """
        Test case for delete_namespaced_role

        
        """
        pass

    def test_delete_namespaced_role_binding(self):
        """
        Test case for delete_namespaced_role_binding

        
        """
        pass

    def test_delete_namespaced_role_binding_restriction(self):
        """
        Test case for delete_namespaced_role_binding_restriction

        
        """
        pass

    def test_delete_namespaced_route(self):
        """
        Test case for delete_namespaced_route

        
        """
        pass

    def test_delete_namespaced_template(self):
        """
        Test case for delete_namespaced_template

        
        """
        pass

    def test_delete_net_namespace(self):
        """
        Test case for delete_net_namespace

        
        """
        pass

    def test_delete_o_auth_access_token(self):
        """
        Test case for delete_o_auth_access_token

        
        """
        pass

    def test_delete_o_auth_authorize_token(self):
        """
        Test case for delete_o_auth_authorize_token

        
        """
        pass

    def test_delete_o_auth_client(self):
        """
        Test case for delete_o_auth_client

        
        """
        pass

    def test_delete_o_auth_client_authorization(self):
        """
        Test case for delete_o_auth_client_authorization

        
        """
        pass

    def test_delete_project(self):
        """
        Test case for delete_project

        
        """
        pass

    def test_delete_user(self):
        """
        Test case for delete_user

        
        """
        pass

    def test_delete_user_identity_mapping(self):
        """
        Test case for delete_user_identity_mapping

        
        """
        pass

    def test_generate_namespaced_deployment_config(self):
        """
        Test case for generate_namespaced_deployment_config

        
        """
        pass

    def test_get_api_resources(self):
        """
        Test case for get_api_resources

        
        """
        pass

    def test_get_oapi_version(self):
        """
        Test case for get_oapi_version

        
        """
        pass

    def test_list_applied_cluster_resource_quota_for_all_namespaces(self):
        """
        Test case for list_applied_cluster_resource_quota_for_all_namespaces

        
        """
        pass

    def test_list_build_config_for_all_namespaces(self):
        """
        Test case for list_build_config_for_all_namespaces

        
        """
        pass

    def test_list_build_for_all_namespaces(self):
        """
        Test case for list_build_for_all_namespaces

        
        """
        pass

    def test_list_cluster_network(self):
        """
        Test case for list_cluster_network

        
        """
        pass

    def test_list_cluster_policy(self):
        """
        Test case for list_cluster_policy

        
        """
        pass

    def test_list_cluster_policy_binding(self):
        """
        Test case for list_cluster_policy_binding

        
        """
        pass

    def test_list_cluster_resource_quota(self):
        """
        Test case for list_cluster_resource_quota

        
        """
        pass

    def test_list_cluster_role(self):
        """
        Test case for list_cluster_role

        
        """
        pass

    def test_list_cluster_role_binding(self):
        """
        Test case for list_cluster_role_binding

        
        """
        pass

    def test_list_deployment_config_for_all_namespaces(self):
        """
        Test case for list_deployment_config_for_all_namespaces

        
        """
        pass

    def test_list_egress_network_policy_for_all_namespaces(self):
        """
        Test case for list_egress_network_policy_for_all_namespaces

        
        """
        pass

    def test_list_group(self):
        """
        Test case for list_group

        
        """
        pass

    def test_list_host_subnet(self):
        """
        Test case for list_host_subnet

        
        """
        pass

    def test_list_identity(self):
        """
        Test case for list_identity

        
        """
        pass

    def test_list_image(self):
        """
        Test case for list_image

        
        """
        pass

    def test_list_image_stream_for_all_namespaces(self):
        """
        Test case for list_image_stream_for_all_namespaces

        
        """
        pass

    def test_list_image_stream_tag_for_all_namespaces(self):
        """
        Test case for list_image_stream_tag_for_all_namespaces

        
        """
        pass

    def test_list_namespaced_applied_cluster_resource_quota(self):
        """
        Test case for list_namespaced_applied_cluster_resource_quota

        
        """
        pass

    def test_list_namespaced_build(self):
        """
        Test case for list_namespaced_build

        
        """
        pass

    def test_list_namespaced_build_config(self):
        """
        Test case for list_namespaced_build_config

        
        """
        pass

    def test_list_namespaced_deployment_config(self):
        """
        Test case for list_namespaced_deployment_config

        
        """
        pass

    def test_list_namespaced_egress_network_policy(self):
        """
        Test case for list_namespaced_egress_network_policy

        
        """
        pass

    def test_list_namespaced_image_stream(self):
        """
        Test case for list_namespaced_image_stream

        
        """
        pass

    def test_list_namespaced_image_stream_tag(self):
        """
        Test case for list_namespaced_image_stream_tag

        
        """
        pass

    def test_list_namespaced_policy(self):
        """
        Test case for list_namespaced_policy

        
        """
        pass

    def test_list_namespaced_policy_binding(self):
        """
        Test case for list_namespaced_policy_binding

        
        """
        pass

    def test_list_namespaced_role(self):
        """
        Test case for list_namespaced_role

        
        """
        pass

    def test_list_namespaced_role_binding(self):
        """
        Test case for list_namespaced_role_binding

        
        """
        pass

    def test_list_namespaced_role_binding_restriction(self):
        """
        Test case for list_namespaced_role_binding_restriction

        
        """
        pass

    def test_list_namespaced_route(self):
        """
        Test case for list_namespaced_route

        
        """
        pass

    def test_list_namespaced_template(self):
        """
        Test case for list_namespaced_template

        
        """
        pass

    def test_list_net_namespace(self):
        """
        Test case for list_net_namespace

        
        """
        pass

    def test_list_o_auth_access_token(self):
        """
        Test case for list_o_auth_access_token

        
        """
        pass

    def test_list_o_auth_authorize_token(self):
        """
        Test case for list_o_auth_authorize_token

        
        """
        pass

    def test_list_o_auth_client(self):
        """
        Test case for list_o_auth_client

        
        """
        pass

    def test_list_o_auth_client_authorization(self):
        """
        Test case for list_o_auth_client_authorization

        
        """
        pass

    def test_list_policy_binding_for_all_namespaces(self):
        """
        Test case for list_policy_binding_for_all_namespaces

        
        """
        pass

    def test_list_policy_for_all_namespaces(self):
        """
        Test case for list_policy_for_all_namespaces

        
        """
        pass

    def test_list_project(self):
        """
        Test case for list_project

        
        """
        pass

    def test_list_project_request(self):
        """
        Test case for list_project_request

        
        """
        pass

    def test_list_role_binding_for_all_namespaces(self):
        """
        Test case for list_role_binding_for_all_namespaces

        
        """
        pass

    def test_list_role_binding_restriction_for_all_namespaces(self):
        """
        Test case for list_role_binding_restriction_for_all_namespaces

        
        """
        pass

    def test_list_role_for_all_namespaces(self):
        """
        Test case for list_role_for_all_namespaces

        
        """
        pass

    def test_list_route_for_all_namespaces(self):
        """
        Test case for list_route_for_all_namespaces

        
        """
        pass

    def test_list_template_for_all_namespaces(self):
        """
        Test case for list_template_for_all_namespaces

        
        """
        pass

    def test_list_user(self):
        """
        Test case for list_user

        
        """
        pass

    def test_patch_cluster_network(self):
        """
        Test case for patch_cluster_network

        
        """
        pass

    def test_patch_cluster_policy(self):
        """
        Test case for patch_cluster_policy

        
        """
        pass

    def test_patch_cluster_policy_binding(self):
        """
        Test case for patch_cluster_policy_binding

        
        """
        pass

    def test_patch_cluster_resource_quota(self):
        """
        Test case for patch_cluster_resource_quota

        
        """
        pass

    def test_patch_cluster_resource_quota_status(self):
        """
        Test case for patch_cluster_resource_quota_status

        
        """
        pass

    def test_patch_cluster_role(self):
        """
        Test case for patch_cluster_role

        
        """
        pass

    def test_patch_cluster_role_binding(self):
        """
        Test case for patch_cluster_role_binding

        
        """
        pass

    def test_patch_group(self):
        """
        Test case for patch_group

        
        """
        pass

    def test_patch_host_subnet(self):
        """
        Test case for patch_host_subnet

        
        """
        pass

    def test_patch_identity(self):
        """
        Test case for patch_identity

        
        """
        pass

    def test_patch_image(self):
        """
        Test case for patch_image

        
        """
        pass

    def test_patch_namespaced_build(self):
        """
        Test case for patch_namespaced_build

        
        """
        pass

    def test_patch_namespaced_build_config(self):
        """
        Test case for patch_namespaced_build_config

        
        """
        pass

    def test_patch_namespaced_deployment_config(self):
        """
        Test case for patch_namespaced_deployment_config

        
        """
        pass

    def test_patch_namespaced_egress_network_policy(self):
        """
        Test case for patch_namespaced_egress_network_policy

        
        """
        pass

    def test_patch_namespaced_image_stream(self):
        """
        Test case for patch_namespaced_image_stream

        
        """
        pass

    def test_patch_namespaced_image_stream_tag(self):
        """
        Test case for patch_namespaced_image_stream_tag

        
        """
        pass

    def test_patch_namespaced_policy(self):
        """
        Test case for patch_namespaced_policy

        
        """
        pass

    def test_patch_namespaced_policy_binding(self):
        """
        Test case for patch_namespaced_policy_binding

        
        """
        pass

    def test_patch_namespaced_role(self):
        """
        Test case for patch_namespaced_role

        
        """
        pass

    def test_patch_namespaced_role_binding(self):
        """
        Test case for patch_namespaced_role_binding

        
        """
        pass

    def test_patch_namespaced_role_binding_restriction(self):
        """
        Test case for patch_namespaced_role_binding_restriction

        
        """
        pass

    def test_patch_namespaced_route(self):
        """
        Test case for patch_namespaced_route

        
        """
        pass

    def test_patch_namespaced_scale_scale(self):
        """
        Test case for patch_namespaced_scale_scale

        
        """
        pass

    def test_patch_namespaced_template(self):
        """
        Test case for patch_namespaced_template

        
        """
        pass

    def test_patch_net_namespace(self):
        """
        Test case for patch_net_namespace

        
        """
        pass

    def test_patch_o_auth_access_token(self):
        """
        Test case for patch_o_auth_access_token

        
        """
        pass

    def test_patch_o_auth_authorize_token(self):
        """
        Test case for patch_o_auth_authorize_token

        
        """
        pass

    def test_patch_o_auth_client(self):
        """
        Test case for patch_o_auth_client

        
        """
        pass

    def test_patch_o_auth_client_authorization(self):
        """
        Test case for patch_o_auth_client_authorization

        
        """
        pass

    def test_patch_project(self):
        """
        Test case for patch_project

        
        """
        pass

    def test_patch_user(self):
        """
        Test case for patch_user

        
        """
        pass

    def test_patch_user_identity_mapping(self):
        """
        Test case for patch_user_identity_mapping

        
        """
        pass

    def test_read_cluster_network(self):
        """
        Test case for read_cluster_network

        
        """
        pass

    def test_read_cluster_policy(self):
        """
        Test case for read_cluster_policy

        
        """
        pass

    def test_read_cluster_policy_binding(self):
        """
        Test case for read_cluster_policy_binding

        
        """
        pass

    def test_read_cluster_resource_quota(self):
        """
        Test case for read_cluster_resource_quota

        
        """
        pass

    def test_read_cluster_resource_quota_status(self):
        """
        Test case for read_cluster_resource_quota_status

        
        """
        pass

    def test_read_cluster_role(self):
        """
        Test case for read_cluster_role

        
        """
        pass

    def test_read_cluster_role_binding(self):
        """
        Test case for read_cluster_role_binding

        
        """
        pass

    def test_read_group(self):
        """
        Test case for read_group

        
        """
        pass

    def test_read_host_subnet(self):
        """
        Test case for read_host_subnet

        
        """
        pass

    def test_read_identity(self):
        """
        Test case for read_identity

        
        """
        pass

    def test_read_image(self):
        """
        Test case for read_image

        
        """
        pass

    def test_read_namespaced_applied_cluster_resource_quota(self):
        """
        Test case for read_namespaced_applied_cluster_resource_quota

        
        """
        pass

    def test_read_namespaced_build(self):
        """
        Test case for read_namespaced_build

        
        """
        pass

    def test_read_namespaced_build_config(self):
        """
        Test case for read_namespaced_build_config

        
        """
        pass

    def test_read_namespaced_build_log_log(self):
        """
        Test case for read_namespaced_build_log_log

        
        """
        pass

    def test_read_namespaced_deployment_config(self):
        """
        Test case for read_namespaced_deployment_config

        
        """
        pass

    def test_read_namespaced_deployment_log_log(self):
        """
        Test case for read_namespaced_deployment_log_log

        
        """
        pass

    def test_read_namespaced_egress_network_policy(self):
        """
        Test case for read_namespaced_egress_network_policy

        
        """
        pass

    def test_read_namespaced_image_stream(self):
        """
        Test case for read_namespaced_image_stream

        
        """
        pass

    def test_read_namespaced_image_stream_image(self):
        """
        Test case for read_namespaced_image_stream_image

        
        """
        pass

    def test_read_namespaced_image_stream_tag(self):
        """
        Test case for read_namespaced_image_stream_tag

        
        """
        pass

    def test_read_namespaced_policy(self):
        """
        Test case for read_namespaced_policy

        
        """
        pass

    def test_read_namespaced_policy_binding(self):
        """
        Test case for read_namespaced_policy_binding

        
        """
        pass

    def test_read_namespaced_role(self):
        """
        Test case for read_namespaced_role

        
        """
        pass

    def test_read_namespaced_role_binding(self):
        """
        Test case for read_namespaced_role_binding

        
        """
        pass

    def test_read_namespaced_role_binding_restriction(self):
        """
        Test case for read_namespaced_role_binding_restriction

        
        """
        pass

    def test_read_namespaced_route(self):
        """
        Test case for read_namespaced_route

        
        """
        pass

    def test_read_namespaced_scale_scale(self):
        """
        Test case for read_namespaced_scale_scale

        
        """
        pass

    def test_read_namespaced_secret_list_secrets(self):
        """
        Test case for read_namespaced_secret_list_secrets

        
        """
        pass

    def test_read_namespaced_template(self):
        """
        Test case for read_namespaced_template

        
        """
        pass

    def test_read_net_namespace(self):
        """
        Test case for read_net_namespace

        
        """
        pass

    def test_read_o_auth_access_token(self):
        """
        Test case for read_o_auth_access_token

        
        """
        pass

    def test_read_o_auth_authorize_token(self):
        """
        Test case for read_o_auth_authorize_token

        
        """
        pass

    def test_read_o_auth_client(self):
        """
        Test case for read_o_auth_client

        
        """
        pass

    def test_read_o_auth_client_authorization(self):
        """
        Test case for read_o_auth_client_authorization

        
        """
        pass

    def test_read_project(self):
        """
        Test case for read_project

        
        """
        pass

    def test_read_user(self):
        """
        Test case for read_user

        
        """
        pass

    def test_read_user_identity_mapping(self):
        """
        Test case for read_user_identity_mapping

        
        """
        pass

    def test_replace_cluster_network(self):
        """
        Test case for replace_cluster_network

        
        """
        pass

    def test_replace_cluster_policy(self):
        """
        Test case for replace_cluster_policy

        
        """
        pass

    def test_replace_cluster_policy_binding(self):
        """
        Test case for replace_cluster_policy_binding

        
        """
        pass

    def test_replace_cluster_resource_quota(self):
        """
        Test case for replace_cluster_resource_quota

        
        """
        pass

    def test_replace_cluster_resource_quota_status(self):
        """
        Test case for replace_cluster_resource_quota_status

        
        """
        pass

    def test_replace_cluster_role(self):
        """
        Test case for replace_cluster_role

        
        """
        pass

    def test_replace_cluster_role_binding(self):
        """
        Test case for replace_cluster_role_binding

        
        """
        pass

    def test_replace_group(self):
        """
        Test case for replace_group

        
        """
        pass

    def test_replace_host_subnet(self):
        """
        Test case for replace_host_subnet

        
        """
        pass

    def test_replace_identity(self):
        """
        Test case for replace_identity

        
        """
        pass

    def test_replace_image(self):
        """
        Test case for replace_image

        
        """
        pass

    def test_replace_namespaced_build(self):
        """
        Test case for replace_namespaced_build

        
        """
        pass

    def test_replace_namespaced_build_config(self):
        """
        Test case for replace_namespaced_build_config

        
        """
        pass

    def test_replace_namespaced_build_details(self):
        """
        Test case for replace_namespaced_build_details

        
        """
        pass

    def test_replace_namespaced_deployment_config(self):
        """
        Test case for replace_namespaced_deployment_config

        
        """
        pass

    def test_replace_namespaced_deployment_config_status(self):
        """
        Test case for replace_namespaced_deployment_config_status

        
        """
        pass

    def test_replace_namespaced_egress_network_policy(self):
        """
        Test case for replace_namespaced_egress_network_policy

        
        """
        pass

    def test_replace_namespaced_image_stream(self):
        """
        Test case for replace_namespaced_image_stream

        
        """
        pass

    def test_replace_namespaced_image_stream_status(self):
        """
        Test case for replace_namespaced_image_stream_status

        
        """
        pass

    def test_replace_namespaced_image_stream_tag(self):
        """
        Test case for replace_namespaced_image_stream_tag

        
        """
        pass

    def test_replace_namespaced_policy(self):
        """
        Test case for replace_namespaced_policy

        
        """
        pass

    def test_replace_namespaced_policy_binding(self):
        """
        Test case for replace_namespaced_policy_binding

        
        """
        pass

    def test_replace_namespaced_role(self):
        """
        Test case for replace_namespaced_role

        
        """
        pass

    def test_replace_namespaced_role_binding(self):
        """
        Test case for replace_namespaced_role_binding

        
        """
        pass

    def test_replace_namespaced_role_binding_restriction(self):
        """
        Test case for replace_namespaced_role_binding_restriction

        
        """
        pass

    def test_replace_namespaced_route(self):
        """
        Test case for replace_namespaced_route

        
        """
        pass

    def test_replace_namespaced_route_status(self):
        """
        Test case for replace_namespaced_route_status

        
        """
        pass

    def test_replace_namespaced_scale_scale(self):
        """
        Test case for replace_namespaced_scale_scale

        
        """
        pass

    def test_replace_namespaced_template(self):
        """
        Test case for replace_namespaced_template

        
        """
        pass

    def test_replace_net_namespace(self):
        """
        Test case for replace_net_namespace

        
        """
        pass

    def test_replace_o_auth_access_token(self):
        """
        Test case for replace_o_auth_access_token

        
        """
        pass

    def test_replace_o_auth_authorize_token(self):
        """
        Test case for replace_o_auth_authorize_token

        
        """
        pass

    def test_replace_o_auth_client(self):
        """
        Test case for replace_o_auth_client

        
        """
        pass

    def test_replace_o_auth_client_authorization(self):
        """
        Test case for replace_o_auth_client_authorization

        
        """
        pass

    def test_replace_project(self):
        """
        Test case for replace_project

        
        """
        pass

    def test_replace_user(self):
        """
        Test case for replace_user

        
        """
        pass

    def test_replace_user_identity_mapping(self):
        """
        Test case for replace_user_identity_mapping

        
        """
        pass


if __name__ == '__main__':
    unittest.main()
