from xld.openshift.connector import OpenShiftConnector
from org.apache.commons.io import IOUtils
from kubernetes.client.rest import ApiException

connector = OpenShiftConnector(deployed.container.container)

input_stream = deployed.file.getInputStream()

try:
    resourceIS = IOUtils.toString(input_stream, "UTF-8")
    print "Content of the file: {0}".format(resourceIS)
finally:
    IOUtils.closeQuietly(input_stream)

resourceDefinition = connector.parse_resource_definition(resourceIS)

try:
    if resourceDefinition["kind"] == "List":
        for resource in resourceDefinition["items"]:
            print("Creating resource %s, kind %s" % (resource["metadata"]["name"], resource["kind"]))
            multi_connector = OpenShiftConnector(deployed.container.container) # openshift top level entry
            multi_connector.create_resource_from_object(namespace=deployed.container.projectName , resource_object=resource)
    else:
        print("Creating resource %s, kind %s" % (resourceDefinition["metadata"]["name"], resourceDefinition["kind"]))
        connector.create_resource_from_object(namespace=deployed.container.projectName , resource_object=resourceDefinition)

except ApiException as e:
    logger.error("%s" % e)
    print("API error while creating resource: %s" % e)
    raise Exception("Resource creation failed.")