from kubernetes.client.models.v1_object_meta import V1ObjectMeta
from kubernetes.client.rest import ApiException
from openshift.client.models import V1ProjectRequest
from xld.openshift.connector import OpenShiftConnector

connector = OpenShiftConnector(deployed.container)

project_request_meta = V1ObjectMeta(name=deployed.projectName, creation_timestamp=None)

project_request = V1ProjectRequest(
    api_version="v1",
    description=deployed.description,
    display_name=deployed.projectDisplayName,
    kind="ProjectRequest",
    metadata=project_request_meta
)

try:
    print("Creating project: %s" % deployed.projectName)
    project_request_response = connector.oapi.create_project_request(project_request.to_dict())

except ApiException as e:
    logger.error("%s" % e)
    print("API error while creating project: %s" % e)
    raise Exception("Project creation failed.")
