# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1ISCSIPersistentVolumeSource(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'chap_auth_discovery': 'bool',
        'chap_auth_session': 'bool',
        'fs_type': 'str',
        'initiator_name': 'str',
        'iqn': 'str',
        'iscsi_interface': 'str',
        'lun': 'int',
        'portals': 'list[str]',
        'read_only': 'bool',
        'secret_ref': 'V1SecretReference',
        'target_portal': 'str'
    }

    attribute_map = {
        'chap_auth_discovery': 'chapAuthDiscovery',
        'chap_auth_session': 'chapAuthSession',
        'fs_type': 'fsType',
        'initiator_name': 'initiatorName',
        'iqn': 'iqn',
        'iscsi_interface': 'iscsiInterface',
        'lun': 'lun',
        'portals': 'portals',
        'read_only': 'readOnly',
        'secret_ref': 'secretRef',
        'target_portal': 'targetPortal'
    }

    def __init__(self, chap_auth_discovery=None, chap_auth_session=None, fs_type=None, initiator_name=None, iqn=None, iscsi_interface=None, lun=None, portals=None, read_only=None, secret_ref=None, target_portal=None):
        """
        V1ISCSIPersistentVolumeSource - a model defined in Swagger
        """

        self._chap_auth_discovery = None
        self._chap_auth_session = None
        self._fs_type = None
        self._initiator_name = None
        self._iqn = None
        self._iscsi_interface = None
        self._lun = None
        self._portals = None
        self._read_only = None
        self._secret_ref = None
        self._target_portal = None
        self.discriminator = None

        if chap_auth_discovery is not None:
          self.chap_auth_discovery = chap_auth_discovery
        if chap_auth_session is not None:
          self.chap_auth_session = chap_auth_session
        if fs_type is not None:
          self.fs_type = fs_type
        if initiator_name is not None:
          self.initiator_name = initiator_name
        self.iqn = iqn
        if iscsi_interface is not None:
          self.iscsi_interface = iscsi_interface
        self.lun = lun
        if portals is not None:
          self.portals = portals
        if read_only is not None:
          self.read_only = read_only
        if secret_ref is not None:
          self.secret_ref = secret_ref
        self.target_portal = target_portal

    @property
    def chap_auth_discovery(self):
        """
        Gets the chap_auth_discovery of this V1ISCSIPersistentVolumeSource.
        whether support iSCSI Discovery CHAP authentication

        :return: The chap_auth_discovery of this V1ISCSIPersistentVolumeSource.
        :rtype: bool
        """
        return self._chap_auth_discovery

    @chap_auth_discovery.setter
    def chap_auth_discovery(self, chap_auth_discovery):
        """
        Sets the chap_auth_discovery of this V1ISCSIPersistentVolumeSource.
        whether support iSCSI Discovery CHAP authentication

        :param chap_auth_discovery: The chap_auth_discovery of this V1ISCSIPersistentVolumeSource.
        :type: bool
        """

        self._chap_auth_discovery = chap_auth_discovery

    @property
    def chap_auth_session(self):
        """
        Gets the chap_auth_session of this V1ISCSIPersistentVolumeSource.
        whether support iSCSI Session CHAP authentication

        :return: The chap_auth_session of this V1ISCSIPersistentVolumeSource.
        :rtype: bool
        """
        return self._chap_auth_session

    @chap_auth_session.setter
    def chap_auth_session(self, chap_auth_session):
        """
        Sets the chap_auth_session of this V1ISCSIPersistentVolumeSource.
        whether support iSCSI Session CHAP authentication

        :param chap_auth_session: The chap_auth_session of this V1ISCSIPersistentVolumeSource.
        :type: bool
        """

        self._chap_auth_session = chap_auth_session

    @property
    def fs_type(self):
        """
        Gets the fs_type of this V1ISCSIPersistentVolumeSource.
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :return: The fs_type of this V1ISCSIPersistentVolumeSource.
        :rtype: str
        """
        return self._fs_type

    @fs_type.setter
    def fs_type(self, fs_type):
        """
        Sets the fs_type of this V1ISCSIPersistentVolumeSource.
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :param fs_type: The fs_type of this V1ISCSIPersistentVolumeSource.
        :type: str
        """

        self._fs_type = fs_type

    @property
    def initiator_name(self):
        """
        Gets the initiator_name of this V1ISCSIPersistentVolumeSource.
        Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.

        :return: The initiator_name of this V1ISCSIPersistentVolumeSource.
        :rtype: str
        """
        return self._initiator_name

    @initiator_name.setter
    def initiator_name(self, initiator_name):
        """
        Sets the initiator_name of this V1ISCSIPersistentVolumeSource.
        Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.

        :param initiator_name: The initiator_name of this V1ISCSIPersistentVolumeSource.
        :type: str
        """

        self._initiator_name = initiator_name

    @property
    def iqn(self):
        """
        Gets the iqn of this V1ISCSIPersistentVolumeSource.
        Target iSCSI Qualified Name.

        :return: The iqn of this V1ISCSIPersistentVolumeSource.
        :rtype: str
        """
        return self._iqn

    @iqn.setter
    def iqn(self, iqn):
        """
        Sets the iqn of this V1ISCSIPersistentVolumeSource.
        Target iSCSI Qualified Name.

        :param iqn: The iqn of this V1ISCSIPersistentVolumeSource.
        :type: str
        """
        if iqn is None:
            raise ValueError("Invalid value for `iqn`, must not be `None`")

        self._iqn = iqn

    @property
    def iscsi_interface(self):
        """
        Gets the iscsi_interface of this V1ISCSIPersistentVolumeSource.
        iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).

        :return: The iscsi_interface of this V1ISCSIPersistentVolumeSource.
        :rtype: str
        """
        return self._iscsi_interface

    @iscsi_interface.setter
    def iscsi_interface(self, iscsi_interface):
        """
        Sets the iscsi_interface of this V1ISCSIPersistentVolumeSource.
        iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).

        :param iscsi_interface: The iscsi_interface of this V1ISCSIPersistentVolumeSource.
        :type: str
        """

        self._iscsi_interface = iscsi_interface

    @property
    def lun(self):
        """
        Gets the lun of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Lun number.

        :return: The lun of this V1ISCSIPersistentVolumeSource.
        :rtype: int
        """
        return self._lun

    @lun.setter
    def lun(self, lun):
        """
        Sets the lun of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Lun number.

        :param lun: The lun of this V1ISCSIPersistentVolumeSource.
        :type: int
        """
        if lun is None:
            raise ValueError("Invalid value for `lun`, must not be `None`")

        self._lun = lun

    @property
    def portals(self):
        """
        Gets the portals of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :return: The portals of this V1ISCSIPersistentVolumeSource.
        :rtype: list[str]
        """
        return self._portals

    @portals.setter
    def portals(self, portals):
        """
        Sets the portals of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :param portals: The portals of this V1ISCSIPersistentVolumeSource.
        :type: list[str]
        """

        self._portals = portals

    @property
    def read_only(self):
        """
        Gets the read_only of this V1ISCSIPersistentVolumeSource.
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.

        :return: The read_only of this V1ISCSIPersistentVolumeSource.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this V1ISCSIPersistentVolumeSource.
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.

        :param read_only: The read_only of this V1ISCSIPersistentVolumeSource.
        :type: bool
        """

        self._read_only = read_only

    @property
    def secret_ref(self):
        """
        Gets the secret_ref of this V1ISCSIPersistentVolumeSource.
        CHAP Secret for iSCSI target and initiator authentication

        :return: The secret_ref of this V1ISCSIPersistentVolumeSource.
        :rtype: V1SecretReference
        """
        return self._secret_ref

    @secret_ref.setter
    def secret_ref(self, secret_ref):
        """
        Sets the secret_ref of this V1ISCSIPersistentVolumeSource.
        CHAP Secret for iSCSI target and initiator authentication

        :param secret_ref: The secret_ref of this V1ISCSIPersistentVolumeSource.
        :type: V1SecretReference
        """

        self._secret_ref = secret_ref

    @property
    def target_portal(self):
        """
        Gets the target_portal of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :return: The target_portal of this V1ISCSIPersistentVolumeSource.
        :rtype: str
        """
        return self._target_portal

    @target_portal.setter
    def target_portal(self, target_portal):
        """
        Sets the target_portal of this V1ISCSIPersistentVolumeSource.
        iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :param target_portal: The target_portal of this V1ISCSIPersistentVolumeSource.
        :type: str
        """
        if target_portal is None:
            raise ValueError("Invalid value for `target_portal`, must not be `None`")

        self._target_portal = target_portal

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1ISCSIPersistentVolumeSource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
