from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector
from xld.openshift.resource_provider import RouteResourceProvider
from xld.openshift.route.route_helper import RouteHelper

result = "SUCCESS"
connector = OpenShiftConnector(deployed.container.container)
route_dict = RouteHelper.read_route(deployed)

try:
    route_resource_provider = RouteResourceProvider(deployed.container)
    routes = route_resource_provider.filter_resources_by_definition(namespace=deployed.container.projectName,
                                                                    resource_definition=route_dict)
    for item in routes.items:
        for ingress in item.status.ingress:
            for condition in ingress.conditions:
                if condition.type == "Admitted" and condition.status == "Unknown":
                    print("Waiting for Route to be activated ...")
                    result = "RETRY"

except ApiException as e:
    print("API error while waiting for route: {0}".format(e))
    raise RuntimeError("Route wait failed.")
