from xld.openshift.route.route_helper import RouteHelper

previous_route_name = previousDeployed.routeName if previousDeployed.routeName else previousDeployed.name
route_name = deployed.routeName if deployed.routeName else deployed.name
if route_name != previous_route_name:
    raise RuntimeError("Route name can't be modified.")

context.addStepWithCheckpoint(steps.jython(
    description="Modify route {0}".format(RouteHelper.get_route_name(deployed)),
    script="xld/openshift/route/update.py",
    order=65
), delta)

context.addStep(steps.jython(
    description="Wait for route {0} to be modified".format(RouteHelper.get_route_name(deployed)),
    script="xld/openshift/route/create_update_wait.py",
    order=66
))
