from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector

with OpenShiftConnector(previousDeployed.container) as connector:
    try:
        print("Deleting project: %s" % previousDeployed.projectName)
        project_delete_response = connector.oapi.delete_project(name=previousDeployed.projectName)

    except ApiException as e:
        logger.error("%s" % e)
        print("API error while deleting project: %s" % e)
        raise Exception("Project deletion failed.")
