from kubernetes.client.rest import ApiException
from xld.openshift.resource_provider import ImageStreamResourceProvider
from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper
from xld.kubernetes.commons.common_utils import CommonUtils

image_stream_dict = ImageStreamHelper.read_image_stream(deployed)
with ImageStreamResourceProvider(deployed.container) as image_stream_resource_provider:
    try:
        print("Creating Image Stream {0}".format(image_stream_dict["metadata"]["name"]))
        CommonUtils.print_request_dump(deployed.container.container, image_stream_dict, image_stream_dict["kind"],
                                       image_stream_dict["apiVersion"])
        image_stream_response = image_stream_resource_provider.create(namespace=deployed.container.projectName,
                                                                      resource_definition=image_stream_dict)
        CommonUtils.print_response_dump(deployed.container.container, image_stream_response)

    except ApiException as e:
        print("API error while creating Image Stream: {0}".format(e))
        raise RuntimeError("Image Stream creation failed.")