from xld.openshift.connector import OpenShiftConnector
from xld.kubernetes.resource.helper import ResourceHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from com.xebialabs.deployit.plugin.openshift.helper import ResourceTemplateHelperScala
import json

class ResourceTemplateHelper(object):

    @staticmethod
    def get_transformed_json(deployed, context):
        template_list, is_json = ResourceHelper(deployed, context).parse()
        template_body = template_list[0]

        container_helper = ContainerHelperFactory(deployed.container).create()
        namespace = container_helper.get_container_name(deployed.container)
        ResourceTemplateHelper.update_params(template_body, deployed)

        api_string_response = ResourceTemplateHelperScala(OpenShiftConnector(deployed.container.container).oapi_java()).createTemplate(namespace, json.dumps(template_body))
        api_response = json.loads(api_string_response)
        transformed = {"kind": "List",
                       "apiVersion": "v1",
                       "metadata": {},
                       "items": []}
        for object in api_response["objects"]:
            transformed['items'].append(object)
        return json.dumps(transformed)

    @staticmethod
    def update_params(template_body, deployed):
        new_params = deployed.parameters
        for param in template_body.get('parameters', ''):
            if param['name'] in new_params:
                if 'generate' in param:
                    del param['generate']
                param['value'] = new_params[param['name']]
