package com.xebialabs.xldeploy.provisioner

import java.util

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.BY_ROOT_NAME
import com.xebialabs.deployit.plugin.api.udm.{TypeIcon, Metadata, Property}
import com.xebialabs.deployit.plugin.api.xld.{Distribution, BaseDictionary}

@Metadata(root = BY_ROOT_NAME, rootName = "ProvisioningEnvironments", description = "Contains key-value pairs that are used to populate placeholders in provisioneds.")
@TypeIcon("icons/types/upm.Dictionary.svg")
class Dictionary extends BaseDictionary {

  @Property(required = false, label = "Restrict to providers", description = "Only apply this dictionary to the providers mentioned", category = "Restrictions")
  val restrictToProviders: util.Set[Provider] = new util.HashSet[Provider]
  @Property(required = false, label = "Restrict to blueprints", description = "Only apply this dictionary to the blueprints mentioned", category = "Restrictions")
  val restrictToBlueprints: util.Set[Blueprint] = new util.HashSet[Blueprint]

  override def getRestrictToContainers: JSet[_ <: Provider] = restrictToProviders

  override def getRestrictToDistributions: JSet[_ <: Distribution] = restrictToBlueprints
}
