package com.xebialabs.xldeploy.provisioner

import java.util

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot._
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}
import com.xebialabs.deployit.plugin.api.xld.Domain
import com.xebialabs.xlplatform.documentation.PublicApiRef

import scala.beans.BeanProperty

@Metadata(description = "Groups provisioning providers and dictionaries and serves as a target for provisioning.", root = BY_ROOT_NAME, rootName = "ProvisioningEnvironments")
@TypeIcon("icons/types/upm.ProvisioningEnvironment.svg")
@PublicApiRef
class ProvisioningEnvironment extends Domain {

  @Property(required = false, label = "Providers", description = "The provisioning providers of this provisioning environment.")
  @BeanProperty
  var providers: util.Set[Provider] = new util.HashSet[Provider]

  @Property(required = false, description = "The dictionaries providing placeholder values. If the same entry exists in multiple dictionaries, the first one in the list is used.")
  @BeanProperty
  var dictionaries: util.List[Dictionary] = new util.ArrayList[Dictionary]

  override def getMembers: JSet[_ <: Provider] = providers
}
