package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem


@Metadata(virtual = true, description = "Base type for all provisioneds.")
@TypeIcon("icons/types/upm.Provisioned.svg")
class Provisioned[D <: Provisionable, C <: Provider] extends BaseConfigurationItem with Deployed[D, C] {

  @Property(description = "The index of the cardinality amount created provisioneds.", required = false)
  @DeployedSpecific
  var ordinal: Int = 0

  @Property(description = "A list of provisioners associated with the instance.", asContainment = true)
  var provisioners: JList[AppliedProvisioner] = new JArrayList[AppliedProvisioner]

  @Property(description = "The set of created CIs.", asContainment = false, required = false)
  @DeployedSpecific
  var boundConfigurationItems: JSet[ConfigurationItem] = new JHashSet[ConfigurationItem]

  @Property(required = false, description = "The provisionable from which this provisioned is derived.")
  @DeployedSpecific
  private var provisionable: D = _

  @Property(asContainment = true, description = "The provider on which this provisioned runs.")
  @DeployedSpecific
  private var provider: C = _

  override def getContainer: C = provider

  override def setContainer(target: C): Unit = provider = target

  override def getDeployable: D = provisionable

  override def setDeployable(source: D): Unit = provisionable = source
}