package com.xebialabs.xldeploy

import java.util

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm._

import scala.reflect.ClassTag

package object provisioner {

  val templatePrefix: String = "template."
  val contextDelimiter: String = "%"
  val literalDelimiter: String = "'"
  val defaultDelimiter: String = "{{ }}"

  type JSet[T] = java.util.Set[T]
  type JList[T] = java.util.List[T]
  type JArrayList[T] = java.util.ArrayList[T]
  type JHashSet[T] = java.util.HashSet[T]
  type JMap[K, V] = java.util.Map[K, V]
  type JHashMap[K, V] = java.util.HashMap[K, V]
  type ProvisionedType = Provisioned[_ <: Provisionable, _ <: Provider]
  type DeployedType = Deployed[_ <: Deployable, _ <: Container]
  type EmbeddedDeployedType = EmbeddedDeployed[_ <: EmbeddedDeployable, _ <: EmbeddedDeployedContainerType]
  type EmbeddedDeployedContainerType = EmbeddedDeployedContainer[_ <: ConfigurationItem, _ <: ConfigurationItem]
  type UdmDictionaryType = com.xebialabs.deployit.plugin.api.udm.Dictionary

  def createCi[T <: ConfigurationItem: ClassTag](id: String): T = {
    createCi(typeOf[T], id)
  }

  def createCi[T <: ConfigurationItem](ciType: String, id: String): T = {
    createCi(typeOf(ciType), id)
  }

  def createCi[T <: ConfigurationItem](ciType: Type, id: String): T = {
    ciType.getDescriptor.newInstance[T](id)
  }

  def typeOf[T <: ConfigurationItem : ClassTag]: Type = {
    Type.valueOf(implicitly[ClassTag[T]].runtimeClass)
  }

  def typeOf(ciType: String): Type = {
    Type.valueOf(ciType)
  }

  implicit class EmptyValue(val value: Any) extends AnyVal {
    def nonEmpty: Boolean = value match {
      case cl: util.Collection[_] => !cl.isEmpty
      case map: util.Map[_, _] => !map.isEmpty
      case st: String => !st.isEmpty
      case v => v != null
    }
  }
}
