import com.xebialabs.deployit.provision.host.LazyHost as LazyHost

script_provisioners = filter(lambda provisioner: provisioner.type == "script.provisioner.ExecutedScript", deployed.provisioners)

for p in script_provisioners:
    host = wrap(LazyHost())
    host.setHostTemplate(p.deployable.hostTemplate)
    host.setProvisionedBlueprint(deployedApplication)
    host.setSourceProvisioned(deployed)
    step_description = "Provision {0} instance with Script provisioner {1} using script file {2}".format(deployed.name,
                                           p.name, p.file.name)
    step = steps.execute_script(targetHost=host,
                                       script=p,
                                       description=step_description)
    context.addStep(step)
