XLRELEASE_HOME=${deployed.container.homeDir}
OLD_INSTALL_DIR=$XLRELEASE_HOME/current-version
NEW_TEMP_DIR=$XLRELEASE_HOME/new 
NEW_INSTALL_DIR=$NEW_TEMP_DIR/${deployed.deployitServerDir}

echo OLD_INSTALL_DIR: $OLD_INSTALL_DIR
echo NEW_TEMP_DIR: $NEW_TEMP_DIR
echo NEW_INSTALL_DIR: $NEW_INSTALL_DIR

cd $XLRELEASE_HOME
mkdir -p $NEW_TEMP_DIR

echo Unzipping archive
unzip -q ${deployed.file} -d $NEW_TEMP_DIR

<#if deployed.container.cleanRepositoryOnUpgrade>
echo Initializing XL release version ${deployed.deployitServerDir}
$NEW_INSTALL_DIR/bin/server.sh -setup -force -reinitialize -setup-defaults  ${step.remoteWorkingDirectory.path}/deployit.conf.defaults
<#else>
echo Upgrading XL release
mv -f $OLD_INSTALL_DIR/conf/* $NEW_INSTALL_DIR/conf/
mv $OLD_INSTALL_DIR/repository $NEW_INSTALL_DIR/
mv -f $OLD_INSTALL_DIR/ext/* $NEW_INSTALL_DIR/ext/
</#if>

echo Removing old version
rm -rf $OLD_INSTALL_DIR/*

echo Putting new version in place
mv $NEW_INSTALL_DIR .
rm -rf $NEW_TEMP_DIR

echo Updating current version
rm current-version
ln -s ${deployed.deployitServerDir} current-version

pwd
ls -la $XLRELEASE_HOME
