/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger log = LoggerFactory.getLogger(TransactionContext.class);
    private static final int STATUS_PREPARING = 1;
    private static final int STATUS_PREPARED = 2;
    private static final int STATUS_COMMITTING = 3;
    private static final int STATUS_COMMITTED = 4;
    private static final int STATUS_ROLLING_BACK = 5;
    private static final int STATUS_ROLLED_BACK = 6;
    private static final ThreadLocal<Xid> CURRENT_XID = new ThreadLocal();
    private final InternalXAResource[] resources;
    private final Xid xid;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private int status;
    private boolean suspended;

    public TransactionContext(Xid xid, InternalXAResource[] resources) {
        this.xid = xid;
        this.resources = resources;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public synchronized void prepare() throws XAException {
        this.bindCurrentXid();
        this.status = 1;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            try {
                this.resources[i].prepare(this);
                continue;
            }
            catch (TransactionException e) {
                txe = e;
                break;
            }
        }
        this.afterOperation();
        this.status = 2;
        if (txe != null) {
            try {
                this.rollback();
            }
            catch (XAException e) {
                // empty catch block
            }
            XAException e = new XAException(104);
            e.initCause(txe);
            throw e;
        }
    }

    public synchronized void commit() throws XAException {
        if (this.status == 6) {
            throw new XAException(6);
        }
        boolean heuristicCommit = false;
        this.bindCurrentXid();
        this.status = 3;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            if (txe != null) {
                try {
                    resource.rollback(this);
                }
                catch (TransactionException e) {
                    log.warn("Unable to rollback changes on " + resource, (Throwable)e);
                }
                continue;
            }
            try {
                resource.commit(this);
                heuristicCommit = true;
                continue;
            }
            catch (TransactionException e) {
                txe = e;
            }
        }
        this.afterOperation();
        this.status = 4;
        this.cleanCurrentXid();
        if (txe != null) {
            XAException e = null;
            e = heuristicCommit ? new XAException(5) : new XAException(6);
            e.initCause(txe);
            throw e;
        }
    }

    public synchronized void rollback() throws XAException {
        if (this.status == 6) {
            throw new XAException(104);
        }
        this.bindCurrentXid();
        this.status = 5;
        this.beforeOperation();
        int errors = 0;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            try {
                resource.rollback(this);
                continue;
            }
            catch (TransactionException e) {
                log.warn("Unable to rollback changes on " + resource, (Throwable)e);
                ++errors;
            }
        }
        this.afterOperation();
        this.status = 6;
        this.cleanCurrentXid();
        if (errors != 0) {
            throw new XAException(104);
        }
    }

    private void beforeOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].beforeOperation(this);
        }
    }

    private void afterOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].afterOperation(this);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    private void bindCurrentXid() {
        CURRENT_XID.set(this.xid);
    }

    private void cleanCurrentXid() {
        CURRENT_XID.set(null);
    }

    private static Xid getCurrentXid() {
        return CURRENT_XID.get();
    }

    public static Object getCurrentThreadId() {
        Xid xid = TransactionContext.getCurrentXid();
        if (xid != null) {
            return new XidWrapper(xid.getGlobalTransactionId());
        }
        return Thread.currentThread();
    }

    public static boolean isSameThreadId(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    private static class XidWrapper {
        private byte[] gtid;

        public XidWrapper(byte[] gtid) {
            this.gtid = gtid;
        }

        public boolean equals(Object other) {
            if (!(other instanceof XidWrapper)) {
                return false;
            }
            return Arrays.equals(this.gtid, ((XidWrapper)other).gtid);
        }

        public int hashCode() {
            return Arrays.hashCode(this.gtid);
        }
    }
}

