/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class NotQuery
extends Query {
    private final Query context;
    private Scorer contextScorer;

    NotQuery(Query context) {
        this.context = context;
    }

    public Weight createWeight(Searcher searcher) {
        return new NotQueryWeight(searcher);
    }

    public String toString(String field) {
        return "NotQuery";
    }

    public void extractTerms(Set<Term> terms) {
        this.context.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.context.rewrite(reader);
        if (cQuery == this.context) {
            return this;
        }
        return new NotQuery(cQuery);
    }

    private class NotQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private int docNo;
        private int contextNo;

        NotQueryScorer(IndexReader reader) {
            super(Similarity.getDefault());
            this.docNo = -1;
            this.contextNo = -1;
            this.reader = reader;
        }

        public int nextDoc() throws IOException {
            int docId;
            if (this.docNo == Integer.MAX_VALUE) {
                return this.docNo;
            }
            if (this.docNo == -1 && (docId = NotQuery.this.contextScorer.nextDoc()) != Integer.MAX_VALUE) {
                this.contextNo = docId;
            }
            do {
                ++this.docNo;
            } while (this.reader.isDeleted(this.docNo) && this.docNo < this.reader.maxDoc());
            while (this.contextNo != -1 && this.contextNo == this.docNo) {
                ++this.docNo;
                docId = NotQuery.this.contextScorer.nextDoc();
                this.contextNo = docId == Integer.MAX_VALUE ? -1 : docId;
            }
            if (this.docNo >= this.reader.maxDoc()) {
                this.docNo = Integer.MAX_VALUE;
            }
            return this.docNo;
        }

        public int docID() {
            return this.docNo;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public int advance(int target) throws IOException {
            if (this.docNo == Integer.MAX_VALUE) {
                return this.docNo;
            }
            if (target == Integer.MAX_VALUE) {
                NotQuery.this.contextScorer.advance(target);
                this.docNo = Integer.MAX_VALUE;
                return this.docNo;
            }
            if (this.contextNo != -1 && this.contextNo < target) {
                int docId = NotQuery.this.contextScorer.advance(target);
                this.contextNo = docId == Integer.MAX_VALUE ? -1 : docId;
            }
            this.docNo = target - 1;
            return this.nextDoc();
        }
    }

    private class NotQueryWeight
    extends Weight {
        private final Searcher searcher;

        NotQueryWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return NotQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            NotQuery.this.contextScorer = NotQuery.this.context.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            if (NotQuery.this.contextScorer == null) {
                return new MatchAllDocsQuery().createWeight(this.searcher).scorer(reader, scoreDocsInOrder, false);
            }
            return new NotQueryScorer(reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

