/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryHits;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortedLuceneQueryHits
extends AbstractQueryHits {
    private static final Logger log = LoggerFactory.getLogger(SortedLuceneQueryHits.class);
    private static final int MAX_FETCH_SIZE = 32768;
    private static final int MIN_FETCH_SIZE = 32;
    private final IndexSearcher searcher;
    private final Query query;
    private final Sort sort;
    private int hitIndex = -1;
    private ScoreDoc[] scoreDocs = new ScoreDoc[0];
    private int size;
    private int numHits;
    private int offset = 0;

    public SortedLuceneQueryHits(IndexSearcher searcher, Query query, Sort sort, long resultFetchHint) throws IOException {
        this.searcher = searcher;
        this.query = query;
        this.sort = sort;
        this.numHits = (int)Math.min(Math.max(resultFetchHint, 32L), 32768L);
        this.getHits();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public ScoreNode nextScoreNode() throws IOException {
        if (++this.hitIndex >= this.size) {
            return null;
        }
        if (this.hitIndex - this.offset >= this.scoreDocs.length) {
            this.numHits = Math.max(this.numHits, this.hitIndex * 2);
            this.getHits();
        }
        ScoreDoc doc = this.scoreDocs[this.hitIndex - this.offset];
        String uuid = this.searcher.doc(doc.doc, FieldSelectors.UUID).get(FieldNames.UUID);
        NodeId id = new NodeId(uuid);
        return new ScoreNode(id, doc.score, doc.doc);
    }

    @Override
    public void skip(int n) throws IOException {
        this.hitIndex += n;
    }

    private void getHits() throws IOException {
        TopFieldCollector collector = TopFieldCollector.create((Sort)this.sort, (int)this.numHits, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        this.searcher.search(this.query, (Collector)collector);
        this.size = collector.getTotalHits();
        this.offset += this.scoreDocs.length;
        this.scoreDocs = collector.topDocs((int)this.offset, (int)this.numHits).scoreDocs;
        log.debug("getHits() {}/{}", (Object)this.scoreDocs.length, (Object)this.numHits);
        this.numHits *= 2;
    }
}

