/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.flat.PropertySequence;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserPerWorkspaceUserManager;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.core.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserImporter
implements ProtectedPropertyImporter,
ProtectedNodeImporter {
    private static final Logger log = LoggerFactory.getLogger(UserImporter.class);
    public static final String PARAM_IMPORT_BEHAVIOR = "importBehavior";
    private JackrabbitSession session;
    private NamePathResolver resolver;
    private ReferenceChangeTracker referenceTracker;
    private UserPerWorkspaceUserManager userManager;
    private boolean initialized = false;
    private boolean resetAutoSave = false;
    private int importBehavior = 1;
    private Membership currentMembership;
    private Map<String, String> currentPw = new HashMap<String, String>(1);

    @Override
    public boolean init(JackrabbitSession session, NamePathResolver resolver, boolean isWorkspaceImport, int uuidBehavior, ReferenceChangeTracker referenceTracker) {
        this.session = session;
        this.resolver = resolver;
        this.referenceTracker = referenceTracker;
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (uuidBehavior == 0) {
            log.debug("ImportUUIDBehavior.IMPORT_UUID_CREATE_NEW isn't supported when importing users or groups.");
            return false;
        }
        if (isWorkspaceImport) {
            log.debug("Only Session-Import is supported when importing users or groups.");
            return false;
        }
        try {
            UserManager uMgr = session.getUserManager();
            if (uMgr instanceof UserPerWorkspaceUserManager) {
                if (uMgr.isAutoSave()) {
                    uMgr.autoSave(false);
                    this.resetAutoSave = true;
                    log.debug("Changed autosave behavior of UserManager to 'false'.");
                }
                this.userManager = (UserPerWorkspaceUserManager)uMgr;
                this.initialized = true;
            } else {
                log.debug("Failed to initialize UserImporter: UserManager isn't instance of UserPerWorkspaceUserManager or does implicit save call.");
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize UserImporter: ", (Throwable)e);
        }
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handlePropInfo(NodeImpl parent, PropInfo protectedPropInfo, QPropertyDefinition def) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        Authorizable a = this.userManager.getAuthorizable(parent);
        if (a == null) {
            log.warn("Cannot handle protected PropInfo " + protectedPropInfo + ". Node " + parent + " doesn't represent a valid Authorizable.");
            return false;
        }
        if (this.userManager.isAutoSave()) {
            this.userManager.autoSave(false);
        }
        try {
            Name propName = protectedPropInfo.getName();
            if (UserConstants.P_PRINCIPAL_NAME.equals(propName)) {
                if (def.isMultiple() || !UserConstants.NT_REP_AUTHORIZABLE.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:principalName");
                    boolean bl = false;
                    return bl;
                }
                Value v = protectedPropInfo.getValues(1, this.resolver)[0];
                String princName = v.getString();
                this.userManager.setPrincipal(parent, (Principal)((Object)new PrincipalImpl(princName)));
                if (parent.isNew()) {
                    if (a.isGroup()) {
                        this.userManager.onCreate((Group)a);
                    } else if (this.currentPw.containsKey(a.getID())) {
                        this.userManager.onCreate((User)a, this.currentPw.remove(a.getID()));
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (UserConstants.P_PASSWORD.equals(propName)) {
                if (a.isGroup()) {
                    log.warn("Expected parent node of type rep:User.");
                    boolean v = false;
                    return v;
                }
                if (def.isMultiple() || !UserConstants.NT_REP_USER.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:password");
                    boolean v = false;
                    return v;
                }
                Value v = protectedPropInfo.getValues(1, this.resolver)[0];
                String pw = v.getString();
                this.userManager.setPassword(parent, pw, false);
                if (parent.isNew()) {
                    if (parent.hasProperty(UserConstants.P_PRINCIPAL_NAME)) {
                        this.userManager.onCreate((User)a, pw);
                    } else {
                        this.currentPw.clear();
                        this.currentPw.put(a.getID(), pw);
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (UserConstants.P_IMPERSONATORS.equals(propName)) {
                if (a.isGroup()) {
                    log.warn("Expected parent node of type rep:User.");
                    boolean v = false;
                    return v;
                }
                if (!def.isMultiple() || !UserConstants.MIX_REP_IMPERSONATABLE.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:impersonators");
                    boolean v = false;
                    return v;
                }
                Value[] vs = protectedPropInfo.getValues(1, this.resolver);
                this.referenceTracker.processedReference(new Impersonators(a.getID(), vs));
                boolean pw = true;
                return pw;
            }
            if (UserConstants.P_DISABLED.equals(propName)) {
                if (a.isGroup()) {
                    log.warn("Expected parent node of type rep:User.");
                    boolean vs = false;
                    return vs;
                }
                if (def.isMultiple() || !UserConstants.NT_REP_USER.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:disabled");
                    boolean vs = false;
                    return vs;
                }
                Value v = protectedPropInfo.getValues(1, this.resolver)[0];
                ((User)a).disable(v.getString());
                boolean pw = true;
                return pw;
            }
            if (UserConstants.P_MEMBERS.equals(propName)) {
                if (!a.isGroup()) {
                    log.warn("Expected parent node of type rep:Group.");
                    boolean v = false;
                    return v;
                }
                if (!def.isMultiple() || !UserConstants.NT_REP_GROUP.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:members");
                    boolean v = false;
                    return v;
                }
                Membership membership = new Membership(a.getID());
                for (Value v : protectedPropInfo.getValues(10, this.resolver)) {
                    membership.addMember(new NodeId(v.getString()));
                }
                this.referenceTracker.processedReference(membership);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.resetAutoSave) {
                this.userManager.autoSave(true);
            }
        }
    }

    @Override
    public boolean handlePropInfo(NodeState parent, PropInfo protectedPropInfo, QPropertyDefinition def) throws RepositoryException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public void processReferences() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.userManager.isAutoSave()) {
            this.userManager.autoSave(false);
        }
        try {
            ArrayList<Object> processed = new ArrayList<Object>();
            Iterator<Object> it = this.referenceTracker.getProcessedReferences();
            while (it.hasNext()) {
                Value[] vs;
                ArrayList<Object> toAdd;
                HashMap<String, Object> toRemove;
                Authorizable a;
                Object reference = it.next();
                if (reference instanceof Membership) {
                    a = this.userManager.getAuthorizable(((Membership)reference).groupId);
                    if (a == null || !a.isGroup()) {
                        throw new RepositoryException(((Membership)reference).groupId + " does not represent a valid group.");
                    }
                    final Group gr = (Group)a;
                    toRemove = new HashMap<String, Object>();
                    Iterator declMembers = gr.getDeclaredMembers();
                    while (declMembers.hasNext()) {
                        Authorizable dm = (Authorizable)declMembers.next();
                        toRemove.put(dm.getID(), dm);
                    }
                    toAdd = new ArrayList<Object>();
                    final ArrayList<Membership.Member> nonExisting = new ArrayList<Membership.Member>();
                    for (Membership.Member member : ((Membership)reference).members) {
                        NodeId remapped = this.referenceTracker.getMappedId(member.id);
                        NodeId id = remapped == null ? member.id : remapped;
                        Authorizable authorz = null;
                        try {
                            NodeImpl n = ((SessionImpl)this.session).getNodeById(id);
                            authorz = this.userManager.getAuthorizable(n);
                        }
                        catch (RepositoryException e) {
                            // empty catch block
                        }
                        if (authorz != null) {
                            if (toRemove.remove(authorz.getID()) != null) continue;
                            toAdd.add(authorz);
                            continue;
                        }
                        this.handleFailure("New member of " + gr + ": No such authorizable (NodeID = " + id + ")");
                        if (this.importBehavior != 2) continue;
                        log.info("ImportBehavior.BESTEFFORT: Remember non-existing member for processing.");
                        nonExisting.add(member);
                    }
                    for (Authorizable m : toRemove.values()) {
                        if (gr.removeMember(m)) continue;
                        this.handleFailure("Failed remove existing member (" + m + ") from " + gr);
                    }
                    for (Authorizable m : toAdd) {
                        if (gr.addMember(m)) continue;
                        this.handleFailure("Failed add member (" + m + ") to " + gr);
                    }
                    if (!nonExisting.isEmpty()) {
                        log.info("ImportBehavior.BESTEFFORT: Found " + nonExisting.size() + " entries of rep:members pointing to non-existing authorizables. Adding to rep:members.");
                        final NodeImpl groupNode = ((AuthorizableImpl)gr).getNode();
                        if (this.userManager.hasMemberSplitSize()) {
                            this.userManager.performProtectedOperation((SessionImpl)this.session, new SessionWriteOperation<Object>(){

                                @Override
                                public Boolean perform(SessionContext context) throws RepositoryException {
                                    NodeImpl nMembers = groupNode.hasNode(UserConstants.N_MEMBERS) ? groupNode.getNode(UserConstants.N_MEMBERS) : groupNode.addNode(UserConstants.N_MEMBERS, UserConstants.NT_REP_MEMBERS, null);
                                    for (Membership.Member member : nonExisting) {
                                        PropertySequence properties = GroupImpl.getPropertySequence(nMembers, UserImporter.this.userManager);
                                        String propName = member.name;
                                        if (propName == null) {
                                            log.debug("Ignoring unnamed user with id {}", (Object)member.id);
                                            continue;
                                        }
                                        if (properties.hasItem(propName)) {
                                            log.debug("Overwriting authorizable {} which is already member of {}.", (Object)propName, (Object)gr);
                                            properties.removeProperty(propName);
                                        }
                                        Value newMember = UserImporter.this.session.getValueFactory().createValue(member.id.toString(), 10);
                                        properties.addProperty(propName, newMember);
                                    }
                                    return null;
                                }
                            });
                        } else {
                            ArrayList<Value> memberValues = new ArrayList<Value>();
                            if (groupNode.hasProperty(UserConstants.P_MEMBERS)) {
                                Value[] vls = groupNode.getProperty(UserConstants.P_MEMBERS).getValues();
                                memberValues.addAll(Arrays.asList(vls));
                            }
                            for (Membership.Member member : nonExisting) {
                                memberValues.add(this.session.getValueFactory().createValue(member.id.toString(), 10));
                            }
                            this.userManager.setProtectedProperty(groupNode, UserConstants.P_MEMBERS, memberValues.toArray(new Value[memberValues.size()]), 10);
                        }
                    }
                    processed.add(reference);
                    continue;
                }
                if (!(reference instanceof Impersonators)) continue;
                a = this.userManager.getAuthorizable(((Impersonators)reference).userId);
                if (a == null || a.isGroup()) {
                    throw new RepositoryException(((Impersonators)reference).userId + " does not represent a valid user.");
                }
                Impersonation imp = ((User)a).getImpersonation();
                toRemove = new HashMap();
                PrincipalIterator pit = imp.getImpersonators();
                while (pit.hasNext()) {
                    Principal princ = pit.nextPrincipal();
                    toRemove.put(princ.getName(), princ);
                }
                toAdd = new ArrayList();
                for (Value v : vs = ((Impersonators)reference).values) {
                    String princName = v.getString();
                    if (toRemove.remove(princName) != null) continue;
                    toAdd.add(new PrincipalImpl(princName));
                }
                for (Principal princ : toRemove.values()) {
                    if (imp.revokeImpersonation(princ)) continue;
                    this.handleFailure("Failed to revoke impersonation for " + princ.getName() + " on " + a);
                }
                for (Principal princ : toAdd) {
                    if (imp.grantImpersonation(princ)) continue;
                    this.handleFailure("Failed to grant impersonation for " + princ.getName() + " on " + a);
                }
                processed.add(reference);
            }
            this.referenceTracker.removeReferences(processed);
        }
        finally {
            if (this.resetAutoSave) {
                this.userManager.autoSave(true);
            }
        }
    }

    @Override
    public boolean start(NodeImpl protectedParent) throws RepositoryException {
        String repMembers = this.resolver.getJCRName(UserConstants.NT_REP_MEMBERS);
        if (repMembers.equals(protectedParent.getPrimaryNodeType().getName())) {
            NodeImpl groupNode = protectedParent;
            while (groupNode.getDepth() != 0 && repMembers.equals(groupNode.getPrimaryNodeType().getName())) {
                groupNode = (NodeImpl)groupNode.getParent();
            }
            Authorizable auth = this.userManager.getAuthorizable(groupNode);
            if (auth == null) {
                log.debug("Cannot handle protected node " + protectedParent + ". It nor one of its parents represent a valid Authorizable.");
                return false;
            }
            this.currentMembership = new Membership(auth.getID());
            return true;
        }
        return false;
    }

    @Override
    public boolean start(NodeState protectedParent) {
        return false;
    }

    @Override
    public void startChildInfo(NodeInfo childInfo, List<PropInfo> propInfos) throws RepositoryException {
        assert (this.currentMembership != null);
        if (UserConstants.NT_REP_MEMBERS.equals(childInfo.getNodeTypeName())) {
            for (PropInfo prop : propInfos) {
                for (Value v : prop.getValues(10, this.resolver)) {
                    String name = this.resolver.getJCRName(prop.getName());
                    NodeId id = new NodeId(v.getString());
                    this.currentMembership.addMember(name, id);
                }
            }
        } else {
            log.warn("{} is not of type {}", (Object)childInfo.getName(), (Object)UserConstants.NT_REP_MEMBERS);
        }
    }

    @Override
    public void endChildInfo() throws RepositoryException {
    }

    @Override
    public void end(NodeImpl protectedParent) throws RepositoryException {
        this.referenceTracker.processedReference(this.currentMembership);
        this.currentMembership = null;
    }

    @Override
    public void end(NodeState protectedParent) {
    }

    public String getImportBehavior() {
        return ImportBehavior.nameFromValue(this.importBehavior);
    }

    public void setImportBehavior(String importBehaviorStr) {
        this.importBehavior = ImportBehavior.valueFromName(importBehaviorStr);
    }

    private void handleFailure(String msg) throws RepositoryException {
        switch (this.importBehavior) {
            case 1: 
            case 2: {
                log.warn(msg);
                break;
            }
            case 3: {
                throw new ConstraintViolationException(msg);
            }
        }
    }

    public static final class ImportBehavior {
        public static final int IGNORE = 1;
        public static final int BESTEFFORT = 2;
        public static final int ABORT = 3;
        public static final String NAME_IGNORE = "ignore";
        public static final String NAME_BESTEFFORT = "besteffort";
        public static final String NAME_ABORT = "abort";

        public static int valueFromName(String behaviorString) {
            if (NAME_IGNORE.equalsIgnoreCase(behaviorString)) {
                return 1;
            }
            if (NAME_BESTEFFORT.equalsIgnoreCase(behaviorString)) {
                return 2;
            }
            if (NAME_ABORT.equalsIgnoreCase(behaviorString)) {
                return 3;
            }
            log.error("Invalid behavior " + behaviorString + " -> Using default: ABORT.");
            return 3;
        }

        public static String nameFromValue(int importBehavior) {
            switch (importBehavior) {
                case 1: {
                    return NAME_IGNORE;
                }
                case 3: {
                    return NAME_ABORT;
                }
                case 2: {
                    return NAME_BESTEFFORT;
                }
            }
            throw new IllegalArgumentException("Invalid import behavior: " + importBehavior);
        }
    }

    private static final class Impersonators {
        private final String userId;
        private final Value[] values;

        private Impersonators(String userId, Value[] values) {
            this.userId = userId;
            this.values = values;
        }
    }

    private static final class Membership {
        private final String groupId;
        private final List<Member> members = new LinkedList<Member>();

        public Membership(String groupId) {
            this.groupId = groupId;
        }

        public void addMember(String name, NodeId id) {
            this.members.add(new Member(name, id));
        }

        public void addMember(NodeId id) {
            this.addMember(null, id);
        }

        public class Member {
            private final String name;
            private final NodeId id;

            public Member(String name, NodeId id) {
                this.name = name;
                this.id = id;
            }
        }
    }
}

