/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalFreeze;
import org.apache.jackrabbit.core.version.InternalFreezeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class InternalFrozenNodeImpl
extends InternalFreezeImpl
implements InternalFrozenNode {
    private PropertyState[] frozenProperties;
    private NodeId frozenUUID = null;
    private Name frozenPrimaryType = null;
    private Set<Name> frozenMixinTypes = null;

    public InternalFrozenNodeImpl(InternalVersionManagerBase vMgr, NodeStateEx node, InternalVersionItem parent) throws RepositoryException {
        super(vMgr, node, parent);
        PropertyState[] props;
        try {
            props = node.getProperties();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        ArrayList<PropertyState> propList = new ArrayList<PropertyState>();
        HashSet<Name> mixins = new HashSet<Name>();
        for (PropertyState prop : props) {
            if (prop.getName().equals(NameConstants.JCR_FROZENUUID)) {
                InternalValue value = node.getPropertyValue(NameConstants.JCR_FROZENUUID);
                if (value.getType() == 1) {
                    this.frozenUUID = new NodeId(value.getString());
                    continue;
                }
                this.frozenUUID = value.getNodeId();
                continue;
            }
            if (prop.getName().equals(NameConstants.JCR_FROZENPRIMARYTYPE)) {
                this.frozenPrimaryType = node.getPropertyValue(NameConstants.JCR_FROZENPRIMARYTYPE).getName();
                continue;
            }
            if (prop.getName().equals(NameConstants.JCR_FROZENMIXINTYPES)) {
                InternalValue[] values = node.getPropertyValues(NameConstants.JCR_FROZENMIXINTYPES);
                if (values == null) continue;
                for (InternalValue value : values) {
                    mixins.add(value.getName());
                }
                continue;
            }
            if (prop.getName().equals(NameConstants.JCR_PRIMARYTYPE) || prop.getName().equals(NameConstants.JCR_UUID)) continue;
            propList.add(prop);
        }
        this.frozenProperties = propList.toArray(new PropertyState[propList.size()]);
        this.frozenMixinTypes = Collections.unmodifiableSet(mixins);
        if (this.frozenPrimaryType == null) {
            throw new RepositoryException("Illegal frozen node. Must have 'frozenPrimaryType'");
        }
    }

    @Override
    public Name getName() {
        return this.node.getName();
    }

    @Override
    public NodeId getId() {
        return this.node.getNodeId();
    }

    @Override
    public List<ChildNodeEntry> getFrozenChildNodes() throws VersionException {
        return this.node.getState().getChildNodeEntries();
    }

    @Override
    public boolean hasFrozenChildNode(Name name, int idx) {
        return this.node.getState().hasChildNodeEntry(name, idx);
    }

    @Override
    public InternalFreeze getFrozenChildNode(Name name, int idx) throws RepositoryException {
        ChildNodeEntry e = this.node.getState().getChildNodeEntry(name, idx);
        return e == null ? null : (InternalFreeze)this.vMgr.getItem(e.getId());
    }

    @Override
    public PropertyState[] getFrozenProperties() {
        return this.frozenProperties;
    }

    @Override
    public NodeId getFrozenId() {
        return this.frozenUUID;
    }

    @Override
    public Name getFrozenPrimaryType() {
        return this.frozenPrimaryType;
    }

    @Override
    public Set<Name> getFrozenMixinTypes() {
        return this.frozenMixinTypes;
    }

    protected static NodeStateEx checkin(NodeStateEx parent, Name name, NodeStateEx src) throws RepositoryException {
        try {
            return InternalFrozenNodeImpl.checkin(parent, name, src, false);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static NodeStateEx checkin(NodeStateEx parent, Name name, NodeStateEx src, boolean forceCopy) throws RepositoryException, ItemStateException {
        NodeStateEx node = parent.addNode(name, NameConstants.NT_FROZENNODE, null, true);
        node.setPropertyValue(NameConstants.JCR_FROZENUUID, InternalValue.create(src.getNodeId().toString()));
        node.setPropertyValue(NameConstants.JCR_FROZENPRIMARYTYPE, InternalValue.create(src.getState().getNodeTypeName()));
        if (src.hasProperty(NameConstants.JCR_MIXINTYPES)) {
            node.setPropertyValues(NameConstants.JCR_FROZENMIXINTYPES, 7, src.getPropertyValues(NameConstants.JCR_MIXINTYPES));
        }
        for (PropertyState prop : src.getProperties()) {
            int opv = forceCopy ? 1 : src.getDefinition(prop).getOnParentVersion();
            Name propName = prop.getName();
            if (opv == 6) {
                parent.reload();
                throw new VersionException("Checkin aborted due to OPV abort in " + propName);
            }
            if (opv != 2 && opv != 1 || propName.equals(NameConstants.JCR_PRIMARYTYPE) || propName.equals(NameConstants.JCR_MIXINTYPES) || propName.equals(NameConstants.JCR_UUID)) continue;
            node.copyFrom(prop);
        }
        boolean isFull = src.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE);
        for (NodeStateEx child : src.getChildNodes()) {
            int opv = forceCopy ? 1 : child.getDefinition().getOnParentVersion();
            if (opv == 6) {
                throw new VersionException("Checkin aborted due to OPV in " + child);
            }
            if (opv == 2) {
                if (isFull && child.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                    NodeId histId = child.getPropertyValue(NameConstants.JCR_VERSIONHISTORY).getNodeId();
                    NodeStateEx newChild = node.addNode(child.getName(), NameConstants.NT_VERSIONEDCHILD, null, false);
                    newChild.setPropertyValue(NameConstants.JCR_CHILDVERSIONHISTORY, InternalValue.create(histId));
                    continue;
                }
                InternalFrozenNodeImpl.checkin(node, child.getName(), child, true);
                continue;
            }
            if (opv != 1) continue;
            InternalFrozenNodeImpl.checkin(node, child.getName(), child, true);
        }
        return node;
    }
}

