/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GzipUtils {
    private static final Map<String, String> compressSuffix = new HashMap<String, String>();
    private static final Map<String, String> uncompressSuffix = new HashMap<String, String>();

    private GzipUtils() {
    }

    public static boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n = lower.length();
        for (int i = 2; i <= 5 && i < n; ++i) {
            if (!uncompressSuffix.containsKey(lower.substring(n - i))) continue;
            return true;
        }
        return false;
    }

    public static String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n = lower.length();
        for (int i = 2; i <= 5 && i < n; ++i) {
            String suffix = uncompressSuffix.get(lower.substring(n - i));
            if (suffix == null) continue;
            return filename.substring(0, n - i) + suffix;
        }
        return filename;
    }

    public static String getCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n = lower.length();
        for (int i = 4; i <= 5 && i < n; ++i) {
            String suffix = compressSuffix.get(lower.substring(n - i));
            if (suffix == null) continue;
            return filename.substring(0, n - i) + suffix;
        }
        return filename + ".gz";
    }

    static {
        compressSuffix.put(".tar", ".tgz");
        compressSuffix.put(".svg", ".svgz");
        compressSuffix.put(".cpio", ".cpgz");
        compressSuffix.put(".wmf", ".wmz");
        compressSuffix.put(".emf", ".emz");
        uncompressSuffix.put(".tgz", ".tar");
        uncompressSuffix.put(".taz", ".tar");
        uncompressSuffix.put(".svgz", ".svg");
        uncompressSuffix.put(".cpgz", ".cpio");
        uncompressSuffix.put(".wmz", ".wmf");
        uncompressSuffix.put(".emz", ".emf");
        uncompressSuffix.put(".gz", "");
        uncompressSuffix.put(".z", "");
        uncompressSuffix.put("-gz", "");
        uncompressSuffix.put("-z", "");
        uncompressSuffix.put("_z", "");
    }
}

