/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.TaskStateView;
import com.xebialabs.deployit.core.rest.api.support.TaskPermissionFilter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.event.TaskAbortedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskArchivedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskAssignedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskCancelledEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStoppedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.PathParam;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskResource
extends AbstractSecuredResource
implements TaskService {
    @Autowired
    private Engine engine;
    @Autowired
    private JcrTaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);

    public void start(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can start the task.");
        }
        this.engine.execute(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    public void cancel(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can cancel the task.");
        }
        this.engine.cancel(taskId);
        EventBusHolder.publish((Object)new TaskCancelledEvent(taskId));
    }

    public void archive(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can archive the task.");
        }
        this.engine.archive(taskId);
        EventBusHolder.publish((Object)new TaskArchivedEvent(taskId));
    }

    public void stop(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can stop the task.");
        }
        try {
            this.engine.stop(taskId);
            EventBusHolder.publish((Object)new TaskStoppedEvent(taskId));
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not stop task %s", taskId), (Throwable)ise);
            throw ise;
        }
    }

    public void abort(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can abort the task.");
        }
        try {
            this.engine.abort(taskId);
            EventBusHolder.publish((Object)new TaskAbortedEvent(taskId));
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not abort task %s", taskId), (Throwable)ise);
            throw ise;
        }
    }

    public TaskState getTask(String taskId) {
        return this.calledByOwner(this.liveOrArchivedTask(taskId));
    }

    public TaskState assign(String taskId, String owner) {
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            task.setOwner(owner);
        } else if (this.hasPermission(DeployitPermissions.TASK_ASSIGN) && task.getOwner().equals(Permissions.getAuthenticatedUserName())) {
            task.setOwner(owner);
        } else {
            throw PermissionDeniedException.withMessage((String)"Neither ADMIN nor TASK_ASSIGN permissions are granted to you or you are not the owner of the task");
        }
        EventBusHolder.publish((Object)new TaskAssignedEvent(taskId, owner));
        return new TaskStateView((TaskWithSteps)task);
    }

    public TaskState takeover(@PathParam(value="taskid") String taskId, @PathParam(value="owner") String owner) {
        String newOwner = Permissions.getAuthenticatedUserName();
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_TAKEOVER, task);
        if (!task.getOwner().equals(owner)) {
            throw PermissionDeniedException.withMessage((String)String.format("You have not specified the correct owner for task [%s], not taking over.", owner));
        }
        task.setOwner(newOwner);
        EventBusHolder.publish((Object)new TaskAssignedEvent(taskId, newOwner));
        return new TaskStateView((TaskWithSteps)task);
    }

    public TaskWithSteps skip(String taskId, List<Integer> stepIds) {
        return this.skip(taskId, stepIds, true);
    }

    public TaskWithSteps unskip(String taskId, List<Integer> stepIds) {
        return this.skip(taskId, stepIds, false);
    }

    private TaskWithSteps skip(String taskId, List<Integer> stepIds, boolean skip) {
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_SKIPSTEP, task);
        if (skip) {
            this.engine.skipSteps(taskId, stepIds);
        } else {
            this.engine.unskipSteps(taskId, stepIds);
        }
        return task;
    }

    private void checkPermission(Permission permission, Task task) {
        if (TaskMetadata.metadataContainsKey((TaskWithSteps)task, (String)"environment_id")) {
            String env = TaskMetadata.getMetadata((TaskWithSteps)task, (String)"environment_id");
            this.checkPermission(permission, env);
        } else {
            this.checkPermission(permission);
        }
    }

    public TaskWithSteps moveStep(String taskId, int stepNr, int newPosition) {
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_MOVESTEP, task);
        this.engine.moveStep(taskId, stepNr, newPosition);
        return task;
    }

    public TaskWithSteps addPause(String taskId, int stepNr) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can add pause to the task.");
        }
        this.engine.addPauseStep(taskId, stepNr);
        return this.engine.retrieve(taskId);
    }

    public StepState getStep(String taskId, int stepNr, DateTime ifModifiedSince) {
        StepState step = this.calledByOwner(this.liveOrArchivedTask(taskId)).getStep(stepNr);
        if (this.hasBeenModifiedSince(step, ifModifiedSince)) {
            return step;
        }
        throw new NotModifiedException();
    }

    protected boolean hasBeenModifiedSince(StepState step, DateTime ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        DateTime lastModifiedCal = step.getCompletionDate();
        if (step instanceof TaskStep) {
            lastModifiedCal = ((TaskStep)step).getLastModificationDate();
        }
        return lastModifiedCal.withMillis(0L).isAfter((ReadableInstant)ifModifiedSince);
    }

    public List<TaskState> getMyCurrentTasks() {
        final String principal = Permissions.getAuthenticatedUserName();
        return Lists.newArrayList((Iterable)this.getAllTasks().filter((Predicate)new Predicate<TaskState>(){

            public boolean apply(TaskState input) {
                return input.getOwner().equals(principal);
            }
        }));
    }

    private FluentIterable<TaskStateView> getAllTasks() {
        return FluentIterable.from((Iterable)this.engine.getAllIncompleteTasks()).transform((Function)new Function<Task, TaskStateView>(){

            public TaskStateView apply(Task input) {
                return new TaskStateView((TaskWithSteps)input);
            }
        });
    }

    public List<TaskState> getAllCurrentTasks() {
        FluentIterable<TaskStateView> tasks = this.getAllTasks();
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            logger.debug("getAllCurrentTasks returning full list as ADMIN");
            return Lists.newArrayList(tasks);
        }
        return Lists.newArrayList((Iterable)tasks.filter((Predicate)new TaskPermissionFilter()));
    }

    public TaskWithSteps getSteps(String taskId) {
        return this.calledByOwner(this.liveOrArchivedTask(taskId));
    }

    public List<TaskState> query(LocalDate begin, LocalDate end) {
        return Lists.newArrayList((Iterable)FluentIterable.from(this.search(begin, end)).transform((Function)new Function<TaskWithSteps, TaskState>(){

            public TaskState apply(TaskWithSteps input) {
                return new TaskStateView(input);
            }
        }));
    }

    public List<TaskWithSteps> export(LocalDate begin, LocalDate end) {
        return Lists.newArrayList(this.search(begin, end));
    }

    private Collection<ArchivedTask> search(LocalDate begin, LocalDate end) {
        if (!this.hasPermission(PlatformPermissions.ADMIN) && !this.hasPermission(DeployitPermissions.REPORT_VIEW)) {
            throw PermissionDeniedException.withMessage((String)"Only user with report#view permission or ADMIN can search the task archive.");
        }
        ArchivedTaskSearchParameters parameters = new ArchivedTaskSearchParameters();
        if (end == null) {
            end = new LocalDate();
        }
        if (begin != null) {
            parameters.createdBetween(begin.toDateTimeAtStartOfDay(), end.toDateTimeAtStartOfDay());
        }
        return this.taskArchive.searchTasks(parameters);
    }

    private boolean isCalledByOwner(String taskId) {
        try {
            this.calledByOwner(this.liveOrArchivedTask(taskId));
            return true;
        }
        catch (PermissionDeniedException e) {
            return false;
        }
    }

    private TaskWithSteps calledByOwner(TaskWithSteps t) {
        String currentUser = Permissions.getAuthenticatedUserName();
        if (!currentUser.equals(t.getOwner()) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can access the task.");
        }
        return t;
    }

    private TaskWithSteps liveOrArchivedTask(String taskId) {
        Task t;
        try {
            t = this.engine.retrieve(taskId);
        }
        catch (TaskNotFoundException e) {
            t = this.taskArchive.getTask(taskId);
        }
        return this.calledByOwner((TaskWithSteps)t);
    }

    public void setTaskArchive(JcrTaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @HttpResponseCodeResult(statusCode=304)
    private static class NotModifiedException
    extends DeployitException {
        private NotModifiedException() {
        }
    }
}

