/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

@Path(value="/task")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface TaskService {
    @GET
    @Path(value="current")
    public List<TaskState> getMyCurrentTasks();

    @GET
    @Path(value="current/all")
    public List<TaskState> getAllCurrentTasks();

    @GET
    @Path(value="{taskid}")
    public TaskState getTask(@PathParam(value="taskid") String var1);

    @GET
    @Path(value="{taskid}/step")
    public TaskWithSteps getSteps(@PathParam(value="taskid") String var1);

    @GET
    @Path(value="{taskid}/step/{stepId}")
    public StepState getStep(@PathParam(value="taskid") String var1, @PathParam(value="stepId") int var2, @HeaderParam(value="If-Modified-Since") DateTime var3);

    @POST
    @Path(value="{taskid}/start")
    public void start(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/stop")
    public void stop(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/abort")
    public void abort(@PathParam(value="taskid") String var1);

    @DELETE
    @Path(value="{taskid}")
    public void cancel(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/archive")
    public void archive(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/skip")
    public TaskWithSteps skip(@PathParam(value="taskid") String var1, List<Integer> var2);

    @POST
    @Path(value="{taskid}/unskip")
    public TaskWithSteps unskip(@PathParam(value="taskid") String var1, List<Integer> var2);

    @POST
    @Path(value="{taskid}/move/{stepId}/{position}")
    public TaskWithSteps moveStep(@PathParam(value="taskid") String var1, @PathParam(value="stepId") int var2, @PathParam(value="position") int var3);

    @POST
    @Path(value="{taskid}/pause/{stepId}")
    public TaskWithSteps addPause(@PathParam(value="taskid") String var1, @PathParam(value="stepId") int var2);

    @POST
    @Path(value="{taskid}/assign/{owner}")
    public TaskState assign(@PathParam(value="taskid") String var1, @PathParam(value="owner") String var2);

    @POST
    @Path(value="{taskid}/takeover/{owner}")
    public TaskState takeover(@PathParam(value="taskid") String var1, @PathParam(value="owner") String var2);

    @GET
    @Path(value="query")
    public List<TaskState> query(@QueryParam(value="begindate") LocalDate var1, @QueryParam(value="enddate") LocalDate var2);

    @GET
    @Path(value="export")
    public List<TaskWithSteps> export(@QueryParam(value="begindate") LocalDate var1, @QueryParam(value="enddate") LocalDate var2);
}

