/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

class CifsFile
extends BaseOverthereFile<CifsConnection> {
    private SmbFile smbFile;

    protected CifsFile(CifsConnection connection, SmbFile smbFile) {
        super(connection);
        this.smbFile = smbFile;
    }

    protected SmbFile getSmbFile() {
        return this.smbFile;
    }

    @Override
    public String getPath() {
        return ((CifsConnection)this.connection).encoder.fromUncPath(this.smbFile.getUncPath());
    }

    @Override
    public String getName() {
        return this.smbFile.getName();
    }

    @Override
    public OverthereFile getParentFile() {
        try {
            return new CifsFile((CifsConnection)this.getConnection(), new SmbFile(this.smbFile.getParent(), ((CifsConnection)this.connection).authentication));
        }
        catch (MalformedURLException exc) {
            return null;
        }
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        try {
            return this.smbFile.exists();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine existence of " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be read: " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be written: " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be executed: " + exc.toString(), exc);
        }
    }

    @Override
    public boolean isFile() throws RuntimeIOException {
        try {
            return this.smbFile.isFile();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is a directory: " + exc.toString(), exc);
        }
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is a directory: " + exc.toString(), exc);
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.smbFile.isHidden();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is hidden: " + exc.toString(), exc);
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.smbFile.lastModified();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine last modification timestamp of " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public long length() throws RuntimeIOException {
        try {
            return this.smbFile.length();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine length of file " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public List<OverthereFile> listFiles() throws RuntimeIOException {
        try {
            this.upgradeToDirectorySmbFile();
            ArrayList files = Lists.newArrayList();
            for (String name : this.smbFile.list()) {
                files.add(this.getFile(name));
            }
            return files;
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        try {
            this.smbFile.mkdir();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot create directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        try {
            this.smbFile.mkdirs();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot create directories " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void renameTo(OverthereFile dest) throws RuntimeIOException {
        if (dest instanceof CifsFile) {
            SmbFile targetSmbFile = ((CifsFile)dest).getSmbFile();
            try {
                this.smbFile.renameTo(targetSmbFile);
            }
            catch (SmbException exc) {
                throw new RuntimeIOException("Cannot move/rename " + this + " to " + dest + ": " + exc.toString(), exc);
            }
        } else {
            throw new RuntimeIOException("Cannot move/rename cifs:" + ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-cifs:" + ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase() + ": file/directory " + dest);
        }
    }

    @Override
    public void setExecutable(boolean executable) {
    }

    @Override
    public void delete() throws RuntimeIOException {
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
                if (this.smbFile.list().length > 0) {
                    throw new RuntimeIOException("Cannot delete non-empty directory " + this);
                }
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        try {
            return this.smbFile.getInputStream();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + exc.toString(), exc);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return this.smbFile.getOutputStream();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for writing: " + exc.toString(), exc);
        }
    }

    private void upgradeToDirectorySmbFile() throws MalformedURLException {
        if (!this.smbFile.getPath().endsWith("/")) {
            this.smbFile = new SmbFile(this.smbFile.getURL() + "/", ((CifsConnection)this.connection).authentication);
        }
    }

    private void refreshSmbFile() throws MalformedURLException {
        this.smbFile = new SmbFile(this.smbFile.getPath(), ((CifsConnection)this.connection).authentication);
    }

    public boolean equals(Object that) {
        if (!(that instanceof CifsFile)) {
            return false;
        }
        return this.getPath().equals(((CifsFile)that).getPath());
    }

    public int hashCode() {
        return this.smbFile.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getConnection() + "/" + this.getPath();
    }
}

