/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.ssh.RegularExpressionPasswordResponseProvider;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshConnection
extends BaseOverthereConnection {
    public static final String PTY_PATTERN = "(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)";
    public static final String NOCD_PSEUDO_COMMAND = "nocd";
    protected final SshConnectionType sshConnectionType;
    protected final String host;
    protected final int port;
    protected final String username;
    protected final String password;
    protected String interactiveKeyboardAuthPromptRegex;
    protected final String privateKeyFile;
    protected final String passphrase;
    protected final boolean allocateDefaultPty;
    protected final boolean openShellBeforeExecute;
    protected String allocatePty;
    protected SSHClient sshClient;
    private static final Pattern ptyPattern = Pattern.compile("(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)");
    private static final Config config = new DefaultConfig();
    @VisibleForTesting
    protected Factory<SSHClient> sshClientFactory = new Factory<SSHClient>(){

        public SSHClient create() {
            return new SSHClient(config);
        }
    };
    private static Logger logger = LoggerFactory.getLogger(SshConnection.class);

    public SshConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper, true);
        this.sshConnectionType = options.getEnum("connectionType", SshConnectionType.class);
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.getInteger("port", 22);
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.host = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.getOptional("password");
        this.interactiveKeyboardAuthPromptRegex = options.get("interactiveKeyboardAuthRegex", ".*Password:[ ]?");
        this.privateKeyFile = (String)options.getOptional("privateKeyFile");
        this.passphrase = (String)options.getOptional("passphrase");
        this.allocateDefaultPty = options.getBoolean("allocateDefaultPty", false);
        if (this.allocateDefaultPty) {
            logger.warn("The allocateDefaultPty connection option has been deprecated in favour of the allocatePty option. See https://github.com/xebialabs/overthere#ssh_allocatePty");
        }
        this.allocatePty = (String)options.getOptional("allocatePty");
        this.openShellBeforeExecute = options.getBoolean("openShellBeforeExecute", false);
    }

    protected void connect() {
        try {
            SSHClient client = (SSHClient)this.sshClientFactory.create();
            client.setConnectTimeout(this.connectionTimeoutMillis);
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            try {
                client.connect(this.host, this.port);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot connect to " + this.host + ":" + this.port, e);
            }
            if (this.privateKeyFile != null) {
                KeyProvider keys;
                if (this.password != null) {
                    logger.warn("The privateKeyFile and password connection options have both been set for the connection {}. Ignoring password and using privateKeyFile.", (Object)this);
                }
                try {
                    keys = this.passphrase == null ? client.loadKeys(this.privateKeyFile) : client.loadKeys(this.privateKeyFile, this.passphrase);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Cannot read key from private key file " + this.privateKeyFile, e);
                }
                client.authPublickey(this.username, new KeyProvider[]{keys});
            } else if (this.password != null) {
                PasswordFinder passwordFinder = this.getPasswordFinder();
                client.auth(this.username, new AuthMethod[]{new AuthPassword(passwordFinder), new AuthKeyboardInteractive((ChallengeResponseProvider)new RegularExpressionPasswordResponseProvider(passwordFinder, this.interactiveKeyboardAuthPromptRegex))});
            }
            this.sshClient = client;
        }
        catch (SSHException e) {
            throw new RuntimeIOException("Cannot connect to " + this, e);
        }
    }

    private PasswordFinder getPasswordFinder() {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return SshConnection.this.password.toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Already disconnected");
        try {
            this.sshClient.disconnect();
        }
        catch (Exception e) {
            logger.error("Unexpected exception received while disconnecting from " + this, (Throwable)e);
        }
        finally {
            this.sshClient = null;
        }
    }

    protected SSHClient getSshClient() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Not (yet) connected");
        return this.sshClient;
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        this.checkParentFile(parent);
        return this.getFile(OverthereUtils.constructPath(parent, child));
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        this.checkParentFile(parent);
        return this.getFile(parent, name);
    }

    protected void checkParentFile(OverthereFile parent) {
        if (!(parent instanceof SshFile)) {
            throw new IllegalStateException("parent is not a file on an SSH host");
        }
        if (parent.getConnection() != this) {
            throw new IllegalStateException("parent is not a file in this connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        Preconditions.checkNotNull((Object)commandLine, (Object)"Cannot execute null command line");
        Preconditions.checkArgument((commandLine.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot execute empty command line");
        CmdLine cmd = this.processCommandLine(commandLine);
        try {
            Session session;
            if (this.openShellBeforeExecute) {
                session = null;
                try {
                    logger.debug("Creating a temporary shell to allow for deferred home dir creation.");
                    session = this.getSshClient().startSession();
                    Session.Shell shell = session.startShell();
                    shell.close();
                }
                finally {
                    Closeables.closeQuietly((Closeable)session);
                }
            }
            session = this.getSshClient().startSession();
            if (this.allocatePty != null && !this.allocatePty.isEmpty()) {
                if (this.allocateDefaultPty) {
                    logger.warn("The allocatePty and allocateDefaultPty connection options have both been set for the connection {}. Ignoring allocateDefaultPty and using allocatePty.", (Object)this);
                }
                Matcher matcher = ptyPattern.matcher(this.allocatePty);
                Preconditions.checkArgument((boolean)matcher.matches(), (String)"Value for allocatePty [%s] does not match pattern \"(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)\"", (Object[])new Object[]{this.allocateDefaultPty});
                String term = matcher.group(1);
                int cols = Integer.valueOf(matcher.group(2));
                int rows = Integer.valueOf(matcher.group(3));
                int width = Integer.valueOf(matcher.group(4));
                int height = Integer.valueOf(matcher.group(5));
                logger.debug("Allocating PTY {}:{}:{}:{}:{}", new Object[]{term, cols, rows, width, height});
                session.allocatePTY(term, cols, rows, width, height, Collections.emptyMap());
            } else if (this.allocateDefaultPty) {
                logger.debug("Allocating default PTY");
                session.allocateDefaultPTY();
            }
            return this.createProcess(session, cmd);
        }
        catch (SSHException e) {
            throw new RuntimeIOException("Cannot execute remote command \"" + cmd.toCommandLine(this.getHostOperatingSystem(), true) + "\" on " + this, e);
        }
    }

    protected CmdLine processCommandLine(CmdLine commandLine) {
        if (this.startsWithPseudoCommand(commandLine, NOCD_PSEUDO_COMMAND)) {
            logger.trace("Not prefixing command line with cd statement because the nocd pseudo command was present, but the pseudo command will be stripped");
            logger.trace("Replacing: {}", (Object)commandLine);
            CmdLine cmd = SshConnection.stripPrefixedPseudoCommand(commandLine);
            logger.trace("With     : {}", (Object)cmd);
            return cmd;
        }
        if (this.getWorkingDirectory() != null) {
            logger.trace("Prefixing command line with cd statement because the current working directory was set");
            logger.trace("Replacing: {}", (Object)commandLine);
            CmdLine cmd = new CmdLine();
            cmd.addArgument("cd");
            cmd.addArgument(this.workingDirectory.getPath());
            cmd.addRaw(this.os.getCommandSeparator());
            for (CmdLineArgument a : commandLine.getArguments()) {
                cmd.add(a);
            }
            logger.trace("With     : {}", (Object)cmd);
            return cmd;
        }
        logger.trace("Not prefixing command line with cd statement because the current working directory was not set");
        logger.trace("Keeping  : {}", (Object)commandLine);
        return commandLine;
    }

    protected boolean startsWithPseudoCommand(CmdLine commandLine, String pseudoCommand) {
        return commandLine.getArguments().size() >= 2 && commandLine.getArguments().get(0).toString(this.os, false).equals(pseudoCommand);
    }

    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, commandLine);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.host + ":" + this.port;
    }

    protected static CmdLine stripPrefixedPseudoCommand(CmdLine commandLine) {
        return new CmdLine().add(commandLine.getArguments().subList(1, commandLine.getArguments().size()));
    }

    protected static CmdLine prefixWithPseudoCommand(CmdLine commandLine, String pseudoCommand) {
        CmdLine nosudoCommandLine = new CmdLine();
        nosudoCommandLine.addArgument(pseudoCommand);
        nosudoCommandLine.add(commandLine.getArguments());
        return nosudoCommandLine;
    }
}

