/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Provider
@Component
public class DeployitExceptionMapper
extends ClosingExceptionMapper<DeployitException>
implements ExceptionMapper<DeployitException> {
    @Override
    public Response handleException(DeployitException exception) {
        String content;
        Response resp;
        this.logger.info("Intercepting DeployitException", (Throwable)exception);
        HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }
        if ((resp = this.checkWhetherWeHideInternals(status, (RuntimeException)exception, content = exception.hasEntity() ? XStreamReaderWriter.getConfiguredXStream().toXML(exception.getEntity()) : Exceptions.getAllMessages((Exception)exception))) != null) {
            return resp;
        }
        Response.ResponseBuilder response = Response.status((int)status);
        response.header("X-Deployit-Exception", (Object)"true");
        response.header("X-Exception-Type", (Object)exception.getClass().getName());
        response.header("X-Path", PathInterceptor.PATH.get());
        if (exception.hasEntity()) {
            response.type("application/xml");
            response.header("X-Entity", (Object)"true");
        } else {
            response.type("text/plain");
        }
        response.entity((Object)content);
        return response.build();
    }
}

