/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.v1;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class License {
    public static final String SIGNATURE_ENDING = "--- End of Signature ---";
    public static final String SIGNATURE_PREAMBLE = "--- Signature (%s) ---";
    public static final String LICENSE_V1_PREAMBLE = "--- License V1 ---";
    public static final Charset LICENSE_FILE_ENCODING = Charsets.UTF_8;
    public static final String LP_LICENSED_TO = "Licensed to";
    public static final String LP_CONTACT = "Contact";
    public static final String LP_EXPIRES_AFTER = "Expires after";
    public static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private final LocalDate expiresAfter;
    private final String licensedTo;
    private final String contact;

    public License(LocalDate expiresAfter, String licensedTo, String contact) {
        Preconditions.checkNotNull((Object)expiresAfter, (Object)"License expiresAfter cannot be null");
        Preconditions.checkNotNull((Object)licensedTo, (Object)"License licensedTo cannot be null");
        Preconditions.checkArgument((!licensedTo.trim().isEmpty() ? 1 : 0) != 0, (Object)"License licensedTo cannot be empty");
        Preconditions.checkNotNull((Object)contact, (Object)"License contact cannot be null");
        Preconditions.checkArgument((!contact.trim().isEmpty() ? 1 : 0) != 0, (Object)"License contact cannot be empty");
        this.expiresAfter = expiresAfter;
        this.licensedTo = licensedTo;
        this.contact = contact;
    }

    public LocalDate getExpiresAfter() {
        return this.expiresAfter;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public String getContact() {
        return this.contact;
    }
}

