/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.deployit.engine.api.security.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DtoWriter {
    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> roles) {
        return Lists.newArrayList((Iterable)Lists.transform(roles, (Function)new Function<com.xebialabs.deployit.security.Role, Role>(){

            public Role apply(com.xebialabs.deployit.security.Role input) {
                return DtoWriter.writeRole(input);
            }
        }));
    }

    private static Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RolePrincipals> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> roles) {
        ArrayList assignments = Lists.newArrayList();
        for (com.xebialabs.deployit.security.Role role : roles) {
            assignments.add(new RolePrincipals(DtoWriter.writeRole(role), (List)Lists.newArrayList((Iterable)role.getPrincipalsAssigned())));
        }
        return assignments;
    }

    public List<RolePermissions> writeRolePermissions(Multimap<com.xebialabs.deployit.security.Role, com.xebialabs.deployit.security.permission.Permission> multimap) {
        ArrayList permissions = Lists.newArrayList();
        for (com.xebialabs.deployit.security.Role role : multimap.keySet()) {
            permissions.add(new RolePermissions(DtoWriter.writeRole(role), DtoWriter.writePermissions(multimap.get((Object)role))));
        }
        return permissions;
    }

    private static List<String> writePermissions(Collection<com.xebialabs.deployit.security.permission.Permission> permissions) {
        return Lists.newArrayList((Iterable)Iterables.transform(permissions, (Function)new Function<com.xebialabs.deployit.security.permission.Permission, String>(){

            public String apply(com.xebialabs.deployit.security.permission.Permission input) {
                return input.getPermissionName();
            }
        }));
    }

    public static List<Permission> writeReferenceDataPermissions(Collection<com.xebialabs.deployit.security.permission.Permission> values) {
        return Lists.newArrayList((Iterable)Iterables.transform(values, (Function)new Function<com.xebialabs.deployit.security.permission.Permission, Permission>(){

            public Permission apply(com.xebialabs.deployit.security.permission.Permission input) {
                String rootNodeName = input.getRoot() != null ? input.getRoot().getRootNodeName() : null;
                return new Permission(input.getPermissionName(), input.getLevel().name(), rootNodeName);
            }
        }));
    }
}

