/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.spi.event.PermissionGrantedEvent;
import com.xebialabs.deployit.engine.spi.event.PermissionRevokedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class PermissionResource
extends AbstractSecuredResource
implements PermissionService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;

    private static Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    public Map<String, Collection<String>> getGrantedPermissions(String roleName) {
        Role role = this.roleService.getRoleForRoleName(roleName);
        return Maps.newHashMap((Map)this.permissionLister.listPermissions(role).asMap());
    }

    public Map<String, Collection<String>> getMyGrantedPermissions() {
        Authentication authentication = Permissions.getAuthentication();
        List roles = this.roleService.getRolesFor(authentication);
        return Maps.newHashMap((Map)this.permissionLister.listPermissions(roles).asMap());
    }

    public boolean isGranted(String permissionName, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Permission permission = Permission.find((String)permissionName);
        Multimap rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        return rolePermissionMultimap.containsEntry((Object)role, (Object)permission);
    }

    public void grant(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.put((Object)role, (Object)PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionGrantedEvent(id, roleName, permission));
    }

    public void revoke(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.remove((Object)role, (Object)PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionRevokedEvent(id, roleName, permission));
    }

    public void checkMyPermission(String permission, String id) {
        this.checkPermission(PermissionResource.getPermission(permission), id);
    }

    public boolean isGrantedToMe(String permission, String id) {
        return PermissionResource.getPermission(permission).getPermissionHandler().hasPermission(id);
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

