/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit393ReportsView
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit393ReportsView.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.9.3 Upgrade: Reports view permissions ***");
        Node securityNode = repository.read("/$configuration/security");
        try {
            if (securityNode.hasProperty("securityPermissions")) {
                Map<String, String> permissionToRoleIds = this.readGlobalPermissions(securityNode);
                String loginGrantedRoles = permissionToRoleIds.get(PlatformPermissions.LOGIN.getPermissionName());
                logger.debug("Found global permissions: {}", permissionToRoleIds);
                logger.info("Granting " + DeployitPermissions.REPORT_VIEW.getPermissionName() + " permission to all the roles that had login permission.");
                permissionToRoleIds.put(DeployitPermissions.REPORT_VIEW.getPermissionName(), loginGrantedRoles);
                this.writeNewGlobalPermissions(securityNode, permissionToRoleIds);
            } else {
                logger.debug("Did not find global permissions.");
            }
            logger.info("*** Done Deployit 3.9.3 upgrade -- Reports view permissions ***");
            return true;
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Could not convert global to local permissions", (Exception)((Object)e));
        }
    }

    private Map<String, String> readGlobalPermissions(Node securityNode) throws RepositoryException {
        Property property = securityNode.getProperty("securityPermissions");
        return JcrUtils.readMap((Property)property);
    }

    private void writeNewGlobalPermissions(Node securityNode, Map<String, String> permissionToRoleIds) throws RepositoryException {
        JcrUtils.writeMap((Node)securityNode, (String)"securityPermissions", permissionToRoleIds);
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.9.3");
    }
}

