/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentOperationCalculator.class);

    public static DeltaSpecificationBuilder calculate(DeltaSpecificationBuilder builder, Set<Deployed> oldDeployeds, Set<Deployed> newDeployeds) {
        Preconditions.checkNotNull(oldDeployeds, (Object)"Cannot calculate on null old Deployeds");
        Preconditions.checkNotNull(newDeployeds, (Object)"Cannot calculate on null new Deployeds");
        if (oldDeployeds.isEmpty()) {
            for (Deployed newDeployed : newDeployeds) {
                builder.create(newDeployed);
            }
        } else if (newDeployeds.isEmpty()) {
            for (Deployed oldDeployed : oldDeployeds) {
                builder.destroy(oldDeployed);
            }
        } else {
            DeploymentOperationCalculator.calculateUpgrade(builder, oldDeployeds, newDeployeds);
        }
        return builder;
    }

    static void calculateUpgrade(DeltaSpecificationBuilder builder, Set<Deployed> oldDeployeds, Set<Deployed> newDeployeds) {
        HashSet olds = Sets.newHashSet(oldDeployeds);
        HashSet news = Sets.newHashSet(newDeployeds);
        for (Deployed old : olds) {
            Deployed aNew = DeploymentOperationCalculator.findSimilar(old, news);
            if (aNew != null) {
                news.remove(aNew);
                if (DeploymentOperationCalculator.isDifferent(old, aNew)) {
                    builder.modify(old, aNew);
                    continue;
                }
                builder.noOp(aNew);
                continue;
            }
            builder.destroy(old);
        }
        for (Deployed aNew : news) {
            builder.create(aNew);
        }
    }

    static Deployed findSimilar(Deployed old, Set<Deployed> news) {
        for (Deployed aNew : news) {
            if (!DeploymentOperationCalculator.isSimilar(old, aNew)) continue;
            return aNew;
        }
        return null;
    }

    static boolean isDifferent(Deployed<?, ?> old, Deployed<?, ?> aNew) {
        logger.debug("Comparing {} to {}", old, aNew);
        if (!old.getType().equals((Object)aNew.getType())) {
            logger.debug("Difference detected: Types do not match: {} <-> {}", (Object)old.getType(), (Object)aNew.getType());
            return true;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)old.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (pd.getName().equals("deployable") || pd.getName().equals("container") || pd.areEqual(old, aNew)) continue;
            logger.debug("Difference detected: Property {} does not match", (Object)pd.getFqn());
            logger.trace("- old Property value {}", pd.get(old));
            logger.trace("- new Property value {}", pd.get(aNew));
            return true;
        }
        return DeploymentOperationCalculator.isDifferent(old.getDeployable(), aNew.getDeployable());
    }

    static boolean isDifferent(Deployable oldDeployable, Deployable newDeployable) {
        if (!oldDeployable.getType().equals((Object)newDeployable.getType())) {
            return true;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)oldDeployable.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (pd.getName().equals("tags") || pd.areEqual((ConfigurationItem)oldDeployable, (ConfigurationItem)newDeployable)) continue;
            return true;
        }
        return false;
    }

    static boolean isSimilar(Deployed old, Deployed aNew) {
        return aNew.getId().equals(old.getId()) && old.getType().equals((Object)aNew.getType());
    }
}

