/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.joda.time.DateTime;

public class JcrArchivedTaskSearchQueryBuilder
extends ArchivedTaskSearchParameters {
    private final ValueFactory values;
    private final QueryObjectModelFactory queries;
    static final String TASK_SELECTOR_NAME = "task";

    public JcrArchivedTaskSearchQueryBuilder(QueryManager qm, ValueFactory vf, ArchivedTaskSearchParameters p) {
        super(p);
        this.values = vf;
        this.queries = qm.getQOMFactory();
    }

    public QueryObjectModel buildQuery() throws RepositoryException {
        ArrayList constraints = Lists.newArrayList();
        this.appendTaskUuidCriteria(constraints);
        this.appendTaskTypeCriteria(constraints);
        this.appendEnvironmentCriteria(constraints);
        this.appendApplicationCriteria(constraints);
        this.appendCloudEnvironmentTemplateCriteria(constraints);
        this.appendAllCloudEnvironmentTemplatesCriteria(constraints);
        this.appendExecutedByCriteria(constraints);
        this.appendStatusCriteria(constraints);
        this.appendDateRangeCriteria(constraints);
        Ordering[] ordering = this.createOrderBy();
        Selector selector = this.queries.selector("deployit:task", TASK_SELECTOR_NAME);
        if (constraints.isEmpty()) {
            return this.queries.createQuery((Source)selector, null, ordering, null);
        }
        return this.queries.createQuery((Source)selector, this.and(constraints), ordering, null);
    }

    private Ordering[] createOrderBy() throws RepositoryException {
        if (this.orderBy != null) {
            Ordering[] ordering = new Ordering[]{this.queries.ascending((DynamicOperand)this.queries.propertyValue(TASK_SELECTOR_NAME, this.orderBy))};
            return ordering;
        }
        return null;
    }

    private void appendTaskUuidCriteria(List<Constraint> constraints) throws RepositoryException {
        if (JcrArchivedTaskSearchQueryBuilder.isNotBlank(this.taskUuid)) {
            constraints.add(this.equalConstraint("$id", this.taskUuid));
        }
    }

    private static boolean isNotBlank(String s) {
        return !Strings.nullToEmpty((String)s).trim().isEmpty();
    }

    private void appendTaskTypeCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.taskTypes.isEmpty()) {
            return;
        }
        ArrayList taskTypeConstraints = Lists.newArrayList();
        for (TaskType tt : this.taskTypes) {
            taskTypeConstraints.add(this.taskTypeConstraint(tt));
        }
        constraints.add(this.or(taskTypeConstraints));
    }

    private void appendEnvironmentCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.environments.isEmpty()) {
            constraints.add((Constraint)this.queries.descendantNode(TASK_SELECTOR_NAME, "/tasks"));
            return;
        }
        ArrayList environmentConstraints = Lists.newArrayList();
        for (String environment : this.environments) {
            environmentConstraints.add(this.environmentConstraint(environment));
        }
        constraints.add(this.or(environmentConstraints));
    }

    private void appendCloudEnvironmentTemplateCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.cloudEnvironmentTemplates.isEmpty()) {
            return;
        }
        ArrayList cloudEnvironmentTemplateConstraints = Lists.newArrayList();
        for (String cet : this.cloudEnvironmentTemplates) {
            cloudEnvironmentTemplateConstraints.add(this.cloudEnvironmentTemplateConstraint(cet));
        }
        constraints.add(this.or(cloudEnvironmentTemplateConstraints));
    }

    private void appendAllCloudEnvironmentTemplatesCriteria(List<Constraint> constraints) throws RepositoryException {
        if (!this.allCloudEnvironmentTemplates) {
            return;
        }
        constraints.add((Constraint)this.queries.propertyExistence(TASK_SELECTOR_NAME, "cloudEnvironmentTemplateId"));
    }

    private void appendApplicationCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.applications.isEmpty()) {
            return;
        }
        ArrayList applicationConstraints = Lists.newArrayList();
        for (ArchivedTaskSearchParameters.Application application : this.applications) {
            applicationConstraints.add(this.applicationConstraint(application));
        }
        constraints.add(this.or(applicationConstraints));
    }

    private void appendExecutedByCriteria(List<Constraint> constraints) throws RepositoryException {
        if (JcrArchivedTaskSearchQueryBuilder.isNotBlank(this.executedBy)) {
            constraints.add(this.equalConstraint("ownerUser", this.executedBy));
        }
    }

    private void appendStatusCriteria(List<Constraint> constraints) throws RepositoryException {
        switch (this.status) {
            case COMPLETED: {
                constraints.add((Constraint)this.queries.and(this.equalConstraint("state", TaskExecutionState.DONE.name()), this.equalConstraint("failureCount", 0L)));
                break;
            }
            case CANCELLED: {
                constraints.add(this.equalConstraint("state", TaskExecutionState.CANCELLED.name()));
                break;
            }
            case COMPLETED_AFTER_RETRY: {
                Constraint stateConstraint = this.equalConstraint("state", TaskExecutionState.DONE.name());
                Constraint failureConstraint = this.greaterThanConstraint("failureCount", 0L);
                constraints.add((Constraint)this.queries.and(stateConstraint, failureConstraint));
            }
        }
    }

    private void appendDateRangeCriteria(List<Constraint> constraints) throws RepositoryException {
        switch (this.dateRangeSearch) {
            case AFTER: {
                DateTime startDateAsCal = JcrArchivedTaskSearchQueryBuilder.cloneAndSetTimeToStartOfDay(this.startDate);
                constraints.add(this.greaterThanOrEqualConstraint("startDate", startDateAsCal));
                break;
            }
            case BEFORE: {
                DateTime endDateAsCal = JcrArchivedTaskSearchQueryBuilder.cloneAndSetTimeToEndOfDay(this.endDate);
                constraints.add(this.lessThanOrEqualConstraint("startDate", endDateAsCal));
                break;
            }
            case BETWEEN: {
                DateTime betweenStartDate = JcrArchivedTaskSearchQueryBuilder.cloneAndSetTimeToStartOfDay(this.startDate);
                DateTime betweenEndDate = JcrArchivedTaskSearchQueryBuilder.cloneAndSetTimeToEndOfDay(this.endDate);
                Constraint startConstraint = this.greaterThanOrEqualConstraint("startDate", betweenStartDate);
                Constraint endConstraint = this.lessThanOrEqualConstraint("startDate", betweenEndDate);
                constraints.add(startConstraint);
                constraints.add(endConstraint);
            }
        }
    }

    private Constraint notEqualConstraint(String propName, String value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.not.equal.to", this.values.createValue(value));
    }

    private Constraint equalConstraint(String propName, String value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.equal.to", this.values.createValue(value));
    }

    private Constraint equalConstraint(String propName, long value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.equal.to", this.values.createValue(value));
    }

    private Constraint greaterThanConstraint(String propName, long value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.greater.than", this.values.createValue(value));
    }

    private Constraint greaterThanOrEqualConstraint(String propName, DateTime value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.greater.than.or.equal.to", this.values.createValue((Calendar)value.toGregorianCalendar()));
    }

    private Constraint lessThanOrEqualConstraint(String propName, DateTime value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.less.than.or.equal.to", this.values.createValue((Calendar)value.toGregorianCalendar()));
    }

    private Constraint addConstraint(String propName, String op, Value v) throws RepositoryException {
        return this.queries.comparison((DynamicOperand)this.queries.propertyValue(TASK_SELECTOR_NAME, propName), op, (StaticOperand)this.queries.literal(v));
    }

    private Constraint environmentConstraint(String environment) throws InvalidQueryException, RepositoryException {
        String path = "/tasks/" + JcrTaskArchive.encodeEnvironmentId(environment);
        return this.queries.descendantNode(TASK_SELECTOR_NAME, path);
    }

    private Constraint cloudEnvironmentTemplateConstraint(String cloudEnvironmentTemplate) throws RepositoryException {
        return this.equalConstraint("cloudEnvironmentTemplateId", JcrTaskArchive.encodeConfigurationId(cloudEnvironmentTemplate));
    }

    private Constraint applicationConstraint(ArchivedTaskSearchParameters.Application application) throws RepositoryException {
        Constraint c = this.equalConstraint("application", application.name);
        if (application.version != null) {
            c = this.queries.and(c, this.equalConstraint("version", application.version));
        }
        return c;
    }

    private Constraint taskTypeConstraint(TaskType taskType) throws RepositoryException {
        Constraint c = this.equalConstraint("deploymentType", taskType.toString());
        return c;
    }

    private Constraint and(List<Constraint> constraints) throws RepositoryException {
        Checks.checkTrue((!constraints.isEmpty() ? 1 : 0) != 0, (String)"List of constraints may not be empty to combine into AND constraint.", (Object[])new Object[0]);
        Constraint andConstraint = constraints.get(0);
        for (int i = 1; i < constraints.size(); ++i) {
            andConstraint = this.queries.and(andConstraint, constraints.get(i));
        }
        return andConstraint;
    }

    private Constraint or(List<Constraint> constraints) throws RepositoryException {
        Checks.checkTrue((!constraints.isEmpty() ? 1 : 0) != 0, (String)"List of constraints may not be empty to combine into OR constraint.", (Object[])new Object[0]);
        Constraint orConstraint = constraints.get(0);
        for (int i = 1; i < constraints.size(); ++i) {
            orConstraint = this.queries.or(orConstraint, constraints.get(i));
        }
        return orConstraint;
    }

    private static DateTime cloneAndSetTimeToStartOfDay(DateTime date) {
        return date.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    private static DateTime cloneAndSetTimeToEndOfDay(DateTime date) {
        return date.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(999);
    }
}

