/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;

class CiNameCache {
    private Map<String, String> idNameCache = Maps.newHashMap();

    void scan(Version version) {
        Application application = version.getApplication();
        this.idNameCache.put(application.getId(), application.getName());
        this.idNameCache.put(version.getId(), version.getName());
        this.scan((ConfigurationItem)version, null);
    }

    private void scan(ConfigurationItem configurationItem, String base) {
        for (PropertyDescriptor propertyDescriptor : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
            if (!EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(propertyDescriptor.getKind()) || !propertyDescriptor.isAsContainment()) continue;
            Collection cis = (Collection)propertyDescriptor.get(configurationItem);
            for (ConfigurationItem ci : cis) {
                String id = CiNameCache.id(base, ci);
                this.idNameCache.put(ci.getId(), id);
                this.scan(ci, id);
            }
        }
    }

    String lookup(ConfigurationItem ci) {
        if (this.idNameCache.containsKey(ci.getId())) {
            return this.idNameCache.get(ci.getId());
        }
        return ci.getId();
    }

    private static String id(String baseId, ConfigurationItem ci) {
        String name = ci.getName();
        return CiNameCache.id(baseId, name);
    }

    static String id(String baseId, String name) {
        return Joiner.on((String)"/").skipNulls().join((Object)baseId, (Object)name, new Object[0]);
    }
}

