/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Metadata(description="Groups infrastructure CIs and dictionaries and serves as a target for deployment.", root=Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class Environment
extends BaseConfigurationItem {
    @Property(required=false, label="Containers", description="The infrastructure components of this Environment")
    private Set<Container> members = Sets.newHashSet();
    @Property(required=false, description="The dictionaries providing placeholder values. If the same entry exists in multiple dicitonaries, the first one in the list is taken.")
    private List<Dictionary> dictionaries = Lists.newArrayList();

    public Environment() {
    }

    public Environment(Container ... members) {
        HashSet memberSet = Sets.newHashSet();
        for (Container each : members) {
            memberSet.add(each);
        }
        this.setMembers(memberSet);
    }

    public Set<Container> getMembers() {
        return this.members;
    }

    public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
        HashSet<Container> matchingMembers = new HashSet<Container>();
        for (Container member : this.getMembers()) {
            if (!classType.isInstance(member)) continue;
            matchingMembers.add(member);
        }
        return matchingMembers;
    }

    public void setMembers(Set<Container> members) {
        this.members = members;
    }

    public void addMember(Container member) {
        this.members.add((Container)Preconditions.checkNotNull((Object)member));
    }

    public List<Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }
}

