/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.generic.ci.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.InspectScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseGenericContainer
extends BaseContainer
implements GenericContainer {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("container", this);
    @Property(required=false, hidden=true, description="Classpath to the script used to start the generic container.")
    private String startScript;
    @Property(defaultValue="90", hidden=true, description="The order of the start container step in the step list.")
    private int startOrder;
    @Property(defaultValue="0", hidden=true, description="The time to wait in seconds for a container start action.")
    private int startWaitTime;
    @Property(required=false, hidden=true, description="Classpath to the script used to stop the generic container.")
    private String stopScript;
    @Property(defaultValue="10", hidden=true, description="The order of the stop container step in the step list.")
    private int stopOrder;
    @Property(defaultValue="0", hidden=true, description="The time to wait in seconds for a container stop action.")
    private int stopWaitTime;
    @Property(required=false, hidden=true, description="Classpath to the script used to restart the generic container.")
    private String restartScript;
    @Property(defaultValue="90", hidden=true, description="The order of the restart container step in the step list.")
    private int restartOrder;
    @Property(required=false, defaultValue="0", hidden=true, description="The time to wait in seconds for a container restart action.")
    private int restartWaitTime;
    @Property(required=false, description="Environment variables for container", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the inspect script.")
    private Set<String> inspectClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the inspect script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> inspectTemplateClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the start script.")
    private Set<String> startClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the start script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> startTemplateClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the stop script.")
    private Set<String> stopClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the stop script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> stopTemplateClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the restart script.")
    private Set<String> restartClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the restart script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> restartTemplateClasspathResources = Sets.newHashSet();

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.executedScriptDelegate((ConfigurationItem)this, name, args, null);
    }

    @Inspect
    public void inspectContainer(InspectionContext ctx) {
        if (Strings.emptyToNull((String)this.getInspectScript()) != null) {
            InspectScriptExecutionStep step = new InspectScriptExecutionStep((ConfigurationItem)this, this.getInspectScript(), (HostContainer)this.getHost(), this.freeMarkerContext, "Inspect " + this);
            step.setTemplateClasspathResources(Lists.newArrayList(this.getInspectTemplateClasspathResources()));
            step.setClasspathResources(Lists.newArrayList(this.getInspectClasspathResources()));
            ctx.addStep((Step)step);
        }
    }

    public String getStartScript() {
        return ConfigurationHolder.resolveExpression(this.startScript, this.freeMarkerContext);
    }

    public void setStartScript(String startScript) {
        this.startScript = startScript;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public void setStartOrder(int startOrder) {
        this.startOrder = startOrder;
    }

    public int getStartWaitTime() {
        return this.startWaitTime;
    }

    public void setStartWaitTime(int startWaitTime) {
        this.startWaitTime = startWaitTime;
    }

    public String getStopScript() {
        return ConfigurationHolder.resolveExpression(this.stopScript, this.freeMarkerContext);
    }

    public void setStopScript(String stopScript) {
        this.stopScript = stopScript;
    }

    public int getStopOrder() {
        return this.stopOrder;
    }

    public void setStopOrder(int stopOrder) {
        this.stopOrder = stopOrder;
    }

    public int getStopWaitTime() {
        return this.stopWaitTime;
    }

    public void setStopWaitTime(int stopWaitTime) {
        this.stopWaitTime = stopWaitTime;
    }

    public String getRestartScript() {
        return ConfigurationHolder.resolveExpression(this.restartScript, this.freeMarkerContext);
    }

    public void setRestartScript(String restartScript) {
        this.restartScript = restartScript;
    }

    public int getRestartOrder() {
        return this.restartOrder;
    }

    public void setRestartOrder(int restartOrder) {
        this.restartOrder = restartOrder;
    }

    public int getRestartWaitTime() {
        return this.restartWaitTime;
    }

    public void setRestartWaitTime(int restartWaitTime) {
        this.restartWaitTime = restartWaitTime;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public String getInspectScript() {
        return ConfigurationHolder.resolveExpression(this.inspectScript, this.freeMarkerContext);
    }

    public void setInspectScript(String inspectScript) {
        this.inspectScript = inspectScript;
    }

    public Set<String> getInspectClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectClasspathResources, this.freeMarkerContext);
    }

    public void setInspectClasspathResources(Set<String> inspectClasspathResources) {
        this.inspectClasspathResources = inspectClasspathResources;
    }

    public Set<String> getInspectTemplateClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectTemplateClasspathResources, this.freeMarkerContext);
    }

    public void setInspectTemplateClasspathResources(Set<String> inspectTemplateClasspathResources) {
        this.inspectTemplateClasspathResources = inspectTemplateClasspathResources;
    }

    public Set<String> getStartClasspathResources() {
        return this.startClasspathResources;
    }

    public void setStartClasspathResources(Set<String> startClasspathResources) {
        this.startClasspathResources = startClasspathResources;
    }

    public Set<String> getStartTemplateClasspathResources() {
        return this.startTemplateClasspathResources;
    }

    public void setStartTemplateClasspathResources(Set<String> startTemplateClasspathResources) {
        this.startTemplateClasspathResources = startTemplateClasspathResources;
    }

    public Set<String> getStopClasspathResources() {
        return this.stopClasspathResources;
    }

    public void setStopClasspathResources(Set<String> stopClasspathResources) {
        this.stopClasspathResources = stopClasspathResources;
    }

    public Set<String> getStopTemplateClasspathResources() {
        return this.stopTemplateClasspathResources;
    }

    public void setStopTemplateClasspathResources(Set<String> stopTemplateClasspathResources) {
        this.stopTemplateClasspathResources = stopTemplateClasspathResources;
    }

    public Set<String> getRestartClasspathResources() {
        return this.restartClasspathResources;
    }

    public void setRestartClasspathResources(Set<String> restartClasspathResources) {
        this.restartClasspathResources = restartClasspathResources;
    }

    public Set<String> getRestartTemplateClasspathResources() {
        return this.restartTemplateClasspathResources;
    }

    public void setRestartTemplateClasspathResources(Set<String> restartTemplateClasspathResources) {
        this.restartTemplateClasspathResources = restartTemplateClasspathResources;
    }
}

