/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.InstructionStep;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.List;

@Metadata(virtual=true, description="A manual process that needs to be performed on a generic container")
public class ManualProcess<D extends Deployable>
extends AbstractDeployed<D> {
    @Property(required=false, description="Mail addresses of recepients.", category="Mail")
    private List<String> toAddresses = Lists.newArrayList();
    @Property(required=false, description="Mail subject", category="Mail")
    private String subject;
    @Property(required=false, description="From mail address. Defaults to SMTPServer fromAddress.", category="Mail")
    private String fromAddress;
    @Property(required=true, hidden=true, description="Classpath to the script that generates the instructions for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that generates the instructions for the modify operation.")
    private String modifyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that generates the instructions for the destroy operation.")
    private String destroyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that generates the instructions for the noop operation.")
    private String noopScript;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb) {
        return this.addStep(ctx, order, script, verb, null);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb, CheckpointInfo checkpoint) {
        if (!Strings.nullToEmpty((String)script).trim().isEmpty()) {
            InstructionStep step = new InstructionStep(order, this.getDescription(verb), (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), script);
            step.setFromAddress(this.getFromAddress());
            step.setMailServer(this.getMailServer(ctx));
            step.setSubject(this.getSubject());
            step.setToAddresses(this.getToAddresses());
            if (checkpoint == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, checkpoint.delta, checkpoint.operation);
            }
            return true;
        }
        return false;
    }

    protected SmtpServer getMailServer(DeploymentPlanningContext ctx) {
        return SmtpServer.getMailServer(ctx);
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        ManualProcess script = (ManualProcess)delta.getDeployed();
        script.create(ctx, delta);
    }

    protected void create(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, this.getCreateOrder(), this.getCreateScript(), this.getCreateVerb(), ManualProcess.checkpoint(delta, Operation.CREATE));
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        boolean modifyStepAdded = this.addStep(ctx, this.getModifyOrder(), this.getModifyScript(), this.getModifyVerb(), ManualProcess.checkpoint(delta, Operation.MODIFY));
        if (!modifyStepAdded) {
            this.executeDestroy(ctx, delta);
            this.executeCreate(ctx, delta);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        ManualProcess previous = (ManualProcess)delta.getPrevious();
        previous.destroy(ctx, delta);
    }

    protected void destroy(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, this.getDestroyOrder(), this.getDestroyScript(), this.getDestroyVerb(), ManualProcess.checkpoint(delta, Operation.DESTROY));
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, this.getNoopOrder(), this.getNoopScript(), this.getNoopVerb());
    }

    public String getCreateScript() {
        return this.resolveExpression(this.createScript);
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return this.resolveExpression(this.modifyScript);
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return this.resolveExpression(this.destroyScript);
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }

    public String getNoopScript() {
        return this.resolveExpression(this.noopScript);
    }

    public void setNoopScript(String noopScript) {
        this.noopScript = noopScript;
    }

    public List<String> getToAddresses() {
        return this.resolveExpression(this.toAddresses);
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getSubject() {
        return this.resolveExpression(this.subject);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAddress() {
        return this.resolveExpression(this.fromAddress);
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    protected static CheckpointInfo checkpoint(Delta delta) {
        return new CheckpointInfo(delta);
    }

    protected static CheckpointInfo checkpoint(Delta delta, Operation operation) {
        return new CheckpointInfo(delta, operation);
    }

    protected static class CheckpointInfo {
        public final Delta delta;
        public final Operation operation;

        CheckpointInfo(Delta delta) {
            this.delta = delta;
            this.operation = delta.getOperation();
        }

        CheckpointInfo(Delta delta, Operation operation) {
            this.delta = delta;
            this.operation = operation;
        }
    }
}

