/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class FsPath
implements Serializable,
Comparable<FsPath> {
    private static final long serialVersionUID = 5798435461242930648L;
    private static final URI DOT = URI.create(".");
    private URI uri;
    @Nullable
    private transient FsMountPoint mountPoint;
    private transient FsEntryName entryName;
    @Nullable
    private volatile transient URI hierarchical;

    @Deprecated
    public static FsPath create(String uri) {
        return FsPath.create(uri, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsPath create(String uri, FsUriModifier modifier) {
        try {
            return new FsPath(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsPath create(URI uri) {
        return FsPath.create(uri, FsUriModifier.NULL);
    }

    public static FsPath create(URI uri, FsUriModifier modifier) {
        try {
            return new FsPath(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public FsPath(String uri) throws URISyntaxException {
        this.parse(new URI(uri), FsUriModifier.NULL);
    }

    @Deprecated
    public FsPath(String uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(new URI(uri), modifier);
    }

    public FsPath(File file) {
        try {
            this.parse(file.toURI(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsPath(URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsPath(URI uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsPath(@CheckForNull FsMountPoint mountPoint, FsEntryName entryName) {
        if (null == mountPoint) {
            this.uri = entryName.toUri();
        } else if (entryName.isRoot()) {
            this.uri = mountPoint.toUri();
        } else {
            URI mpu = mountPoint.toUri();
            if (mpu.isOpaque()) {
                try {
                    String mpussp = mpu.getRawSchemeSpecificPart();
                    int mpusspl = mpussp.length();
                    URI enu = entryName.toUri();
                    String enup = enu.getRawPath();
                    int enupl = enup.length();
                    String enuq = enu.getRawQuery();
                    int enuql = null == enuq ? 0 : enuq.length() + 1;
                    StringBuilder ssp = new StringBuilder(mpusspl + enupl + enuql).append(mpussp).append(enup);
                    if (null != enuq) {
                        ssp.append('?').append(enuq);
                    }
                    this.uri = new UriBuilder(true).scheme(mpu.getScheme()).path(ssp.toString()).fragment(enu.getRawFragment()).getUri();
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            } else {
                this.uri = mpu.resolve(entryName.toUri());
            }
        }
        this.mountPoint = mountPoint;
        this.entryName = entryName;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri, FsUriModifier modifier) throws URISyntaxException {
        if (null != (uri = modifier.modify(uri, FsUriModifier.PostFix.PATH)).getRawFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment not allowed");
        }
        if (uri.isOpaque()) {
            URI mpu;
            URI nuri;
            String ssp = uri.getRawSchemeSpecificPart();
            int i = ssp.lastIndexOf("!/");
            if (0 > i) {
                throw new QuotedUriSyntaxException(uri, "Missing mount point separator \"!/\"");
            }
            UriBuilder b = new UriBuilder(true);
            this.mountPoint = new FsMountPoint(b.scheme(uri.getScheme()).path(ssp.substring(0, i + 2)).toUri(), modifier);
            this.entryName = new FsEntryName(b.clear().pathQuery(ssp.substring(i + 2)).fragment(uri.getRawFragment()).toUri(), modifier);
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new URI((mpu = this.mountPoint.toUri()).getScheme() + ':' + mpu.getRawSchemeSpecificPart() + this.entryName.toUri()))) {
                uri = nuri;
            }
        } else if (uri.isAbsolute()) {
            this.mountPoint = new FsMountPoint(uri.resolve(DOT), modifier);
            this.entryName = new FsEntryName(this.mountPoint.toUri().relativize(uri), modifier);
        } else {
            this.mountPoint = null;
            this.entryName = new FsEntryName(uri, modifier);
            if (FsUriModifier.NULL != modifier) {
                uri = this.entryName.toUri();
            }
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (null == this.toUri().getRawFragment());
        assert (null != this.getMountPoint() == this.toUri().isAbsolute());
        assert (null != this.getEntryName());
        if (this.toUri().isOpaque()) {
            assert (this.toUri().getRawSchemeSpecificPart().contains("!/"));
        } else if (this.toUri().isAbsolute()) {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.toUri().equals(this.getMountPoint().toUri().resolve(this.getEntryName().toUri())));
        } else {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.getEntryName().toUri() == this.toUri());
        }
        return true;
    }

    public URI toUri() {
        return this.uri;
    }

    @Deprecated
    public URI getUri() {
        return this.uri;
    }

    public URI toHierarchicalUri() {
        if (null != this.hierarchical) {
            return this.hierarchical;
        }
        if (this.uri.isOpaque()) {
            URI mpu = this.mountPoint.toHierarchicalUri();
            URI enu = this.entryName.toUri();
            try {
                this.hierarchical = enu.toString().isEmpty() ? mpu : new UriBuilder(mpu, true).path(mpu.getRawPath() + "/").getUri().resolve(enu);
                return this.hierarchical;
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.hierarchical = this.uri;
        return this.hierarchical;
    }

    @Deprecated
    public URI getHierarchicalUri() {
        return this.toHierarchicalUri();
    }

    @Nullable
    public FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    public FsEntryName getEntryName() {
        return this.entryName;
    }

    public FsPath resolve(FsEntryName entryName) {
        if (entryName.isRoot() && null == this.uri.getQuery()) {
            return this;
        }
        return new FsPath(this.mountPoint, new FsEntryName(this.entryName, entryName));
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsPath && this.uri.equals(((FsPath)that).uri);
    }

    @Override
    public int compareTo(FsPath that) {
        return this.uri.compareTo(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

