/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.JointEnumeration;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class ServiceLocator {
    private final ClassLoader l1;

    public ServiceLocator() {
        this(null);
    }

    public ServiceLocator(@CheckForNull ClassLoader loader) {
        this.l1 = null != loader ? loader : ClassLoader.getSystemClassLoader();
    }

    public <S> Iterator<S> getServices(Class<S> service) {
        ClassLoader l2 = Thread.currentThread().getContextClassLoader();
        return this.l1 == l2 ? ServiceLoader.load(service, this.l1).iterator() : new JointIterator<S>(ServiceLoader.load(service, this.l1).iterator(), ServiceLoader.load(service, l2).iterator());
    }

    @Nullable
    public <S> S getService(Class<S> service, @CheckForNull Class<? extends S> def) {
        String name = System.getProperty(service.getName(), null == def ? null : def.getName());
        if (null == name) {
            return null;
        }
        try {
            return (S)this.getClass(name).newInstance();
        }
        catch (ClassCastException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
        catch (InstantiationException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
    }

    public Class<?> getClass(String name) {
        try {
            return this.l1.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            try {
                ClassLoader l2 = Thread.currentThread().getContextClassLoader();
                if (this.l1 == l2) {
                    throw ex;
                }
                return l2.loadClass(name);
            }
            catch (ClassNotFoundException ex2) {
                throw new ServiceConfigurationError(ex2.toString(), ex2);
            }
        }
    }

    public Enumeration<URL> getResources(String name) {
        ClassLoader l2 = Thread.currentThread().getContextClassLoader();
        try {
            return this.l1 == l2 ? this.l1.getResources(name) : new JointEnumeration<URL>(this.l1.getResources(name), l2.getResources(name));
        }
        catch (IOException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
    }

    @CheckForNull
    public static <T> T promote(@CheckForNull Object object, Class<T> type) {
        try {
            if (object instanceof String && !type.equals(String.class)) {
                object = new ServiceLocator(type.getClassLoader()).getClass((String)((Object)object));
            }
        }
        catch (ServiceConfigurationError ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            if (object instanceof Class && !type.equals(Class.class)) {
                object = ((Class)object).newInstance();
            }
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (null != object && !type.isInstance(object)) {
            throw new IllegalArgumentException();
        }
        return (T)object;
    }
}

