/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import nl.javadude.scannit.scanner.AbstractScanner;

public class Configuration {
    Set<AbstractScanner> scanners = Sets.newHashSet();
    Set<String> prefixes = Sets.newHashSet();

    private Configuration() {
    }

    public static Configuration config() {
        return new Configuration();
    }

    public Configuration with(AbstractScanner ... scanners) {
        for (AbstractScanner scanner : scanners) {
            this.scanners.add(scanner);
        }
        return this;
    }

    public Configuration scan(String prefix) {
        this.prefixes.add(prefix);
        return this;
    }

    void wireScanners() {
        Collection predicates = Collections2.transform(this.prefixes, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String input) {
                return Configuration.this.toFilter(input);
            }
        });
        Predicate or = Predicates.or((Iterable)predicates);
        for (AbstractScanner scanner : this.scanners) {
            scanner.addFilter((Predicate<CharSequence>)or);
        }
    }

    private Predicate<CharSequence> toFilter(String prefix) {
        return Predicates.containsPattern((String)(prefix.replace(".", "\\.") + ".*"));
    }
}

