/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.io.SignerInputStream;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsECCUtils;
import org.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsSigner;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int n, Vector vector, int[] nArray, short[] sArray, short[] sArray2) {
        super(n, vector, nArray, sArray, sArray2);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        int n = -1;
        if (this.namedCurves == null) {
            n = 23;
        } else {
            for (int i = 0; i < this.namedCurves.length; ++i) {
                int n2 = this.namedCurves[i];
                if (!TlsECCUtils.isSupportedNamedCurve(n2)) continue;
                n = n2;
                break;
            }
        }
        ECDomainParameters eCDomainParameters = null;
        if (n >= 0) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(n);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65281)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65282)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(7);
        }
        if (eCDomainParameters == null) {
            throw new TlsFatalAlert(80);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsECCUtils.generateECKeyPair(this.context.getSecureRandom(), eCDomainParameters);
        this.ecAgreeServerPrivateKey = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        byte[] byArray = TlsECCUtils.serializeECPublicKey(this.clientECPointFormats, (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n < 0) {
            TlsECCUtils.writeExplicitECParameters(this.clientECPointFormats, eCDomainParameters, byteArrayOutputStream);
        } else {
            TlsECCUtils.writeNamedECParameters(n, byteArrayOutputStream);
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        CombinedHash combinedHash = new CombinedHash();
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        combinedHash.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        combinedHash.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        combinedHash.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[combinedHash.getDigestSize()];
        combinedHash.doFinal(byArray3, 0);
        byte[] byArray4 = this.serverCredentials.generateCertificateSignature(byArray3);
        TlsUtils.writeOpaque16(byArray4, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initVerifyer(this.tlsSigner, securityParameters);
        SignerInputStream signerInputStream = new SignerInputStream(inputStream, signer);
        ECDomainParameters eCDomainParameters = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, signerInputStream);
        byte[] byArray = TlsUtils.readOpaque8(signerInputStream);
        byte[] byArray2 = TlsUtils.readOpaque16(inputStream);
        if (!signer.verifySignature(byArray2)) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreeServerPublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, eCDomainParameters, byArray));
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

