/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable;
import com.xebialabs.deployit.plugin.api.validation.FileEncodings;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="The supertype of all DeployableArtifacts.")
public class BaseDeployableArtifact
extends BaseDeployable
implements DeployableArtifact {
    private OverthereFile file;
    @Property(required=false, category="Placeholders", description="Whether to scan this artifact for placeholders when it is imported", defaultValue="true")
    private boolean scanPlaceholders;
    @Property(required=false, category="Placeholders", description="Placeholders detected in this artifact")
    private Set<String> placeholders = Sets.newTreeSet();
    @Property(required=false, category="Placeholders", description="The delimiters used indicate placeholders, defaults to '{{ }}'. This is a 5 character string with a space in the middle, the first two are the leading delimiter, the last two are the closing delimiter", defaultValue="{{ }}", hidden=true)
    @Regex(pattern=".. ..")
    private String delimiters = "{{ }}";
    @Property(hidden=true, category="Placeholders", description="Regular expression that matches file names of text files", defaultValue=".+\\.(cfg | conf | config | ini | properties | props | txt | asp | aspx | htm | html | jsf | jsp | xht | xhtml | sql | xml | xsd | xsl | xslt)")
    private String textFileNamesRegex;
    @Property(required=false, category="Placeholders", description="Regular expression that matches file names that must be excluded from scanning")
    private String excludeFileNamesRegex;
    @Property(required=false, category="Deployment", description="The checksum used to detect differences on the artifact. If not provided, it will be calculated by Deployit.")
    private String checksum;
    @Property(required=false, category="Placeholders", description="A map that maps regular expressions matching the full path of file(s) in the artifact to character set encodings", hidden=true, defaultValue=".+\\.properties:ISO-8859-1")
    @FileEncodings
    private Map<String, String> fileEncodings;

    @Override
    public OverthereFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public boolean isScanPlaceholders() {
        return this.scanPlaceholders;
    }

    public void setScanPlaceholders(boolean scanPlaceholders) {
        this.scanPlaceholders = scanPlaceholders;
    }

    @Override
    public Set<String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public String getTextFileNamesRegex() {
        return this.textFileNamesRegex;
    }

    public void setTextFileNamesRegex(String textFileNamesRegex) {
        this.textFileNamesRegex = textFileNamesRegex;
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return this.excludeFileNamesRegex;
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return this.fileEncodings;
    }

    public void setExcludeFileNamesRegex(String excludeFileNamesRegex) {
        this.excludeFileNamesRegex = excludeFileNamesRegex;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }
}

