/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.UnableToValidateLicenseException;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.v1.License;
import java.io.File;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private File licenseFile;
    private License license;
    private final String product;

    @Override
    public boolean isLicenseExpired() {
        if (this.license != null && !LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter())) {
            return false;
        }
        this.readLicense();
        return this.license == null || LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter());
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    public LicenseServiceImpl(String licenseFileName, String product) throws IOException {
        this.product = product;
        this.licenseFile = new File(licenseFileName);
        if (this.isLicenseExpired()) {
            log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
            log.warn("*** Place a valid license in {} to continue using the product.", (Object)this.licenseFile.getAbsolutePath());
        }
    }

    private void readLicense() {
        String licenseFilePath = this.licenseFile.getAbsolutePath();
        if (!this.licenseFile.exists()) {
            log.warn("*** License file {} not found.", (Object)licenseFilePath);
            return;
        }
        try {
            log.info("Reading license from file {}", (Object)licenseFilePath);
            License readLicense = LicenseReader.readLicense((File)this.licenseFile);
            log.info("Product              : {}", (Object)readLicense.getProduct());
            log.info("Licensed to          : {}", (Object)readLicense.getLicensedTo());
            log.info("License contact      : {}", (Object)readLicense.getContact());
            log.info("License expires after: {}", (Object)readLicense.getExpiresAfter());
            if (!readLicense.getProduct().equals(this.product)) {
                log.warn("*** License is not for " + this.product);
                return;
            }
            this.license = readLicense;
        }
        catch (InvalidLicenseException ex) {
            log.warn("*** License is invalid: {}", (Object)ex.getMessage());
            return;
        }
        catch (UnableToValidateLicenseException ex) {
            log.warn("*** License could not be validated.", (Object)licenseFilePath);
            log.warn(ex.getMessage(), (Throwable)ex);
            return;
        }
        if (LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter())) {
            log.warn("*** License has expired.");
        }
    }
}

