/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.DeferredHash;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsCompression;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsNullCipher;
import org.bouncycastle.crypto.tls.TlsNullCompression;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsUtils;

class RecordStream {
    private static int PLAINTEXT_LIMIT = 16384;
    private static int COMPRESSED_LIMIT = PLAINTEXT_LIMIT + 1024;
    private static int CIPHERTEXT_LIMIT = COMPRESSED_LIMIT + 1024;
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCompression pendingCompression = null;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private long readSeqNo = 0L;
    private long writeSeqNo = 0L;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsContext context = null;
    private TlsHandshakeHash hash = null;
    private ProtocolVersion readVersion = null;
    private ProtocolVersion writeVersion = null;
    private boolean restrictReadVersion = true;

    RecordStream(TlsProtocol tlsProtocol, InputStream inputStream, OutputStream outputStream) {
        this.handler = tlsProtocol;
        this.input = inputStream;
        this.output = outputStream;
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher(this.context);
    }

    void init(TlsContext tlsContext) {
        this.context = tlsContext;
        this.hash = new DeferredHash();
        this.hash.init(tlsContext);
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion protocolVersion) {
        this.readVersion = protocolVersion;
    }

    void setWriteVersion(ProtocolVersion protocolVersion) {
        this.writeVersion = protocolVersion;
    }

    void setRestrictReadVersion(boolean bl) {
        this.restrictReadVersion = bl;
    }

    void notifyHelloComplete() {
        this.hash = this.hash.commit();
    }

    void setPendingConnectionState(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.pendingCompression = tlsCompression;
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCompression = this.pendingCompression;
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = 0L;
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCompression = this.pendingCompression;
        this.readCipher = this.pendingCipher;
        this.readSeqNo = 0L;
    }

    void finaliseHandshake() throws IOException {
        if (this.readCompression != this.pendingCompression || this.writeCompression != this.pendingCompression || this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCompression = null;
        this.pendingCipher = null;
    }

    public void readRecord() throws IOException {
        int n;
        short s = TlsUtils.readUint8(this.input);
        RecordStream.checkType(s, (short)10);
        if (!this.restrictReadVersion) {
            n = TlsUtils.readVersionRaw(this.input);
            if ((n & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion protocolVersion = TlsUtils.readVersion(this.input);
            if (this.readVersion == null) {
                this.readVersion = protocolVersion;
            } else if (!protocolVersion.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        n = TlsUtils.readUint16(this.input);
        byte[] byArray = this.decodeAndVerify(s, this.input, n);
        this.handler.processRecord(s, byArray, 0, byArray.length);
    }

    protected byte[] decodeAndVerify(short s, InputStream inputStream, int n) throws IOException {
        RecordStream.checkLength(n, CIPHERTEXT_LIMIT, (short)22);
        byte[] byArray = TlsUtils.readFully(n, inputStream);
        byte[] byArray2 = this.readCipher.decodeCiphertext(this.readSeqNo++, s, byArray, 0, byArray.length);
        RecordStream.checkLength(byArray2.length, COMPRESSED_LIMIT, (short)22);
        OutputStream outputStream = this.readCompression.decompress(this.buffer);
        if (outputStream != this.buffer) {
            outputStream.write(byArray2, 0, byArray2.length);
            outputStream.flush();
            byArray2 = this.getBufferContents();
        }
        RecordStream.checkLength(byArray2.length, PLAINTEXT_LIMIT, (short)30);
        return byArray2;
    }

    protected void writeRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        byte[] byArray3;
        OutputStream outputStream;
        RecordStream.checkType(s, (short)80);
        RecordStream.checkLength(n2, PLAINTEXT_LIMIT, (short)80);
        if (n2 < 1 && s != 23) {
            throw new TlsFatalAlert(80);
        }
        if (s == 22) {
            this.updateHandshakeData(byArray, n, n2);
        }
        if ((outputStream = this.writeCompression.compress(this.buffer)) == this.buffer) {
            byArray3 = this.writeCipher.encodePlaintext(this.writeSeqNo++, s, byArray, n, n2);
        } else {
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            byArray2 = this.getBufferContents();
            RecordStream.checkLength(byArray2.length, n2 + 1024, (short)80);
            byArray3 = this.writeCipher.encodePlaintext(this.writeSeqNo++, s, byArray2, 0, byArray2.length);
        }
        RecordStream.checkLength(byArray3.length, CIPHERTEXT_LIMIT, (short)80);
        byArray2 = new byte[byArray3.length + 5];
        TlsUtils.writeUint8(s, byArray2, 0);
        TlsUtils.writeVersion(this.writeVersion, byArray2, 1);
        TlsUtils.writeUint16(byArray3.length, byArray2, 3);
        System.arraycopy(byArray3, 0, byArray2, 5, byArray3.length);
        this.output.write(byArray2);
        this.output.flush();
    }

    void updateHandshakeData(byte[] byArray, int n, int n2) {
        this.hash.update(byArray, n, n2);
    }

    byte[] getCurrentHash(byte[] byArray) {
        TlsHandshakeHash tlsHandshakeHash = this.hash.fork();
        if (this.context.getServerVersion().isSSL() && byArray != null) {
            tlsHandshakeHash.update(byArray, 0, byArray.length);
        }
        return RecordStream.doFinal(tlsHandshakeHash);
    }

    protected void close() throws IOException {
        IOException iOException = null;
        try {
            this.input.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.output.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void flush() throws IOException {
        this.output.flush();
    }

    private byte[] getBufferContents() {
        byte[] byArray = this.buffer.toByteArray();
        this.buffer.reset();
        return byArray;
    }

    private static byte[] doFinal(Digest digest) {
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    private static void checkType(short s, short s2) throws IOException {
        switch (s) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new TlsFatalAlert(s2);
            }
        }
    }

    private static void checkLength(int n, int n2, short s) throws IOException {
        if (n > n2) {
            throw new TlsFatalAlert(s);
        }
    }
}

