/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;

class PathMapper {
    private static final String DRIVE_DESIGNATOR = ":";
    private static final String ADMIN_SHARE_DESIGNATOR = "$";
    private static final Pattern ADMIN_SHARE_PATTERN = Pattern.compile("[a-zA-Z]" + Pattern.quote("$"));
    private final SortedMap<String, String> sharesForPaths;
    private final Map<String, String> pathsForShares;

    @VisibleForTesting
    PathMapper(Map<String, String> mappings) {
        ImmutableSortedMap.Builder sharesForPath = ImmutableSortedMap.reverseOrder();
        ImmutableMap.Builder pathsForShare = ImmutableMap.builder();
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            String pathPrefixToMatch = mapping.getKey();
            String shareForPathPrefix = mapping.getValue();
            sharesForPath.put((Object)pathPrefixToMatch.toLowerCase(), (Object)shareForPathPrefix);
            pathsForShare.put((Object)shareForPathPrefix.toLowerCase(), (Object)pathPrefixToMatch);
        }
        this.sharesForPaths = sharesForPath.build();
        this.pathsForShares = pathsForShare.build();
    }

    @VisibleForTesting
    String toSharedPath(String path) {
        final String lowerCasePath = path.toLowerCase();
        String mappedPathPrefix = (String)Iterables.find(this.sharesForPaths.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return lowerCasePath.startsWith(input);
            }
        }, null);
        return mappedPathPrefix != null ? (String)this.sharesForPaths.get(mappedPathPrefix) + path.substring(mappedPathPrefix.length()) : path.substring(0, 1) + ADMIN_SHARE_DESIGNATOR + path.substring(2);
    }

    @VisibleForTesting
    String toLocalPath(String path) {
        final String lowerCasePath = path.toLowerCase();
        String mappedShare = (String)Iterables.find(this.pathsForShares.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return lowerCasePath.startsWith(input);
            }
        }, null);
        if (mappedShare != null) {
            return this.pathsForShares.get(mappedShare) + path.substring(mappedShare.length());
        }
        if (path.length() >= 2 && ADMIN_SHARE_PATTERN.matcher(path.substring(0, 2)).matches()) {
            return path.substring(0, 1) + DRIVE_DESIGNATOR + path.substring(2);
        }
        throw new IllegalArgumentException(String.format("Remote path name '%s' uses unrecognized (i.e. neither mapped nor administrative) share", path));
    }
}

