/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

public class ArtifactCopyStep
extends BaseDeploymentStep {
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private String description;
    private boolean preserveExistingFiles;

    public ArtifactCopyStep(int order, OverthereFile sourceFile, HostContainer container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Preconditions.checkNotNull((Object)targetPath);
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        OverthereFile remoteFile;
        Preconditions.checkNotNull((Object)this.targetFileName);
        OverthereFile localFile = this.resolveSourceFile();
        Preconditions.checkNotNull((Object)localFile);
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetPath);
        if (!remoteDir.exists()) {
            if (this.createTargetPath) {
                this.getCtx().logOutput("Creating path " + this.targetPath + " on host " + this.getContainer().getHost());
                remoteDir.mkdirs();
            } else if (localFile.isFile()) {
                this.getCtx().logError("Path " + this.targetPath + " on host " + this.getContainer().getHost() + " does not exist.");
                return StepExitCode.FAIL;
            }
        } else if (this.preserveExistingFiles) {
            this.getCtx().logOutput(remoteDir.getPath() + " already exists on host " + this.getContainer().getHost() + ". Leave it.");
            return StepExitCode.SUCCESS;
        }
        if (localFile.isDirectory()) {
            remoteFile = remoteDir;
        } else {
            remoteFile = remoteDir.getFile(this.getTargetFileName());
            if (remoteFile.exists() && !this.preserveExistingFiles) {
                this.getCtx().logOutput(remoteFile.getPath() + " already exists on host " + this.getContainer().getHost() + ". Will replace.");
                remoteFile.delete();
            }
        }
        this.getCtx().logOutput("Copying " + localFile.getPath() + " to " + remoteFile.getPath() + " on host " + this.getContainer().getHost());
        localFile.copyTo(remoteFile);
        return StepExitCode.SUCCESS;
    }

    protected OverthereFile resolveSourceFile() {
        Preconditions.checkNotNull((Object)this.sourceFile);
        return this.sourceFile;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return "Copy " + this.getSourceFileDescription() + " to " + this.getContainer().getHost();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isPreserveExistingFiles() {
        return this.preserveExistingFiles;
    }

    public void setPreserveExistingFiles(boolean preserveExistingFiles) {
        this.preserveExistingFiles = preserveExistingFiles;
    }
}

