/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshInteractiveSudoPasswordHandlingStream;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import java.io.InputStream;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveSudoConnection
extends SshSudoConnection {
    private String passwordPromptRegex;
    private static final String OVERRIDE_ALLOCATE_PTY = "vt220:80:24:0:0";
    private static final Logger logger = LoggerFactory.getLogger(SshInteractiveSudoConnection.class);

    public SshInteractiveSudoConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        this.passwordPromptRegex = options.get("sudoPasswordPromptRegex", ".*[Pp]assword.*:");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("*") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("?") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((this.password != null ? 1 : 0) != 0, (String)"Cannot start a ssh:%s: connection without a password", (Object[])new Object[]{this.sshConnectionType.toString().toLowerCase()});
        if (!this.allocateDefaultPty && this.allocatePty == null) {
            logger.warn("An ssh:{}: connection requires a pty, allocating a pty with spec [vt220:80:24:0:0].", (Object)this.sshConnectionType.toString().toLowerCase());
            this.allocatePty = OVERRIDE_ALLOCATE_PTY;
        }
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, commandLine){

            @Override
            public InputStream getStdout() {
                return new SshInteractiveSudoPasswordHandlingStream(super.getStdout(), this.getStdin(), SshInteractiveSudoConnection.this.password, SshInteractiveSudoConnection.this.passwordPromptRegex);
            }
        };
    }
}

