/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class DeploymentWriter {
    static Deployment createDeployment(DeployedApplication deployedApplication, Deployment.DeploymentType type) {
        Deployment deployment = new Deployment();
        deployment.setId("deployment-" + UUID.randomUUID().toString());
        deployment.setDeploymentType(type);
        deployment.setDeployedApplication((ConfigurationItem)deployedApplication);
        deployment.setDeployables(DeploymentWriter.sort(Lists.newArrayList((Iterable)Iterables.transform((Iterable)deployedApplication.getVersion().getDeployables(), (Function)DtoReader.ciToCiId))));
        deployment.setContainers(DeploymentWriter.sort(Lists.newArrayList((Iterable)Iterables.transform((Iterable)deployedApplication.getEnvironment().getMembers(), (Function)DtoReader.ciToCiId))));
        return deployment;
    }

    private static List<ConfigurationItemId> sort(List<ConfigurationItemId> toBeSorted) {
        Collections.sort(toBeSorted, new Comparator<ConfigurationItemId>(){

            @Override
            public int compare(ConfigurationItemId o1, ConfigurationItemId o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return toBeSorted;
    }

    static List<ConfigurationItem> convertDeployeds(ListMultimap<Boolean, ConfigurationItem> initialDeployeds) {
        ArrayList deployeds = Lists.newArrayList();
        deployeds.addAll(initialDeployeds.get((Object)true));
        for (ConfigurationItem configurationItem : initialDeployeds.get((Object)false)) {
            ValidatedConfigurationItem vci = new ValidatedConfigurationItem(configurationItem);
            vci.getValidations().add(new ValidationMessage(configurationItem.getId(), "source", "The deployable for this deployed is missing from the package."));
            deployeds.add(vci);
        }
        for (ConfigurationItem deployed : initialDeployeds.values()) {
            DeploymentWriter.addEmbeddeds(deployed, deployeds);
        }
        return deployeds;
    }

    private static void addEmbeddeds(ConfigurationItem deployed, List<ConfigurationItem> collector) {
        FluentIterable propertyDescriptors = FluentIterable.from((Iterable)deployed.getType().getDescriptor().getPropertyDescriptors()).filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return DeploymentWriter.isEmbeddedDeployedProperty(input);
            }
        });
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Collection c = (Collection)propertyDescriptor.get(deployed);
            for (ConfigurationItem configurationItem : c) {
                DeploymentWriter.addEmbeddeds(configurationItem, collector);
            }
            collector.addAll(c);
        }
    }

    private static boolean isEmbeddedDeployedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

