/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.support;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPermissionFilter
implements Predicate<TaskState> {
    private static final Logger logger = LoggerFactory.getLogger(TaskPermissionFilter.class);

    public boolean apply(TaskState taskState) {
        String envId = TaskMetadata.getMetadata((TaskState)taskState, (String)"environment_id");
        TaskType taskType = this.getTaskType(taskState);
        if (envId == null || taskType == null) {
            logger.debug("including non deployment task {}", (Object)taskState.getId());
            return true;
        }
        switch (taskType) {
            case INITIAL: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.DEPLOY_INITIAL, envId)) break;
                logger.debug("including task {} user has initial deploy rights on {}", (Object)taskState.getId(), (Object)envId);
                return true;
            }
            case UPGRADE: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.DEPLOY_UPGRADE, envId)) break;
                logger.debug("including task {} user has upgrade rights on {}", (Object)taskState.getId(), (Object)envId);
                return true;
            }
            case INSPECTION: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.DISCOVERY)) break;
                logger.debug("including task {} user has discovery rights", (Object)taskState.getId());
                return true;
            }
            case CONTROL: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.CONTROLTASK_EXECUTE, envId)) break;
                logger.debug("including task {} user has controltask rights on {}", (Object)taskState.getId(), (Object)envId);
                return true;
            }
            case UNDEPLOY: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.UNDEPLOY, envId)) break;
                logger.debug("including task {} user has undeploy rights on {}", (Object)taskState.getId(), (Object)envId);
                return true;
            }
            case ROLLBACK: {
                if (!TaskPermissionFilter.hasPermission(DeployitPermissions.DEPLOY_UPGRADE, envId) && !TaskPermissionFilter.hasPermission(DeployitPermissions.DEPLOY_INITIAL, envId)) break;
                logger.debug("including task {} user has undeploy rights on {}", (Object)taskState.getId(), (Object)envId);
                return true;
            }
        }
        return false;
    }

    private TaskType getTaskType(TaskState taskState) {
        try {
            return TaskType.valueOf((String)TaskMetadata.getMetadata((TaskState)taskState, (String)"taskType"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static boolean hasPermission(Permission permission) {
        return TaskPermissionFilter.hasPermission(permission, null);
    }

    protected static boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }
}

