/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class PasswordEncrypter {
    private static final Base64Coder BASE_64_CODER = new Base64Coder();
    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference();
    private final SecretKey passwordEncryptionKey;

    private PasswordEncrypter(SecretKey passwordEncryptionKey) {
        this.passwordEncryptionKey = passwordEncryptionKey;
    }

    public static void init(SecretKey secretKey) {
        PasswordEncrypter passwordEncrypter = new PasswordEncrypter(secretKey);
        instance.set(passwordEncrypter);
    }

    public static PasswordEncrypter getInstance() {
        Preconditions.checkState((instance.get() != null ? 1 : 0) != 0, (Object)"PasswordEncrypter not yet set, please construct one.");
        return instance.get();
    }

    public boolean isEncoded(String text) {
        try {
            BASE_64_CODER.decode(text.getBytes());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEncrypted(String text) {
        if (this.isEncoded(text)) {
            byte[] decode = BASE_64_CODER.decode(text.getBytes());
            try {
                Cipher cipher = this.getCipher(2);
                cipher.doFinal(decode);
                return true;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    public String encrypt(String plaintext) {
        Checks.checkArgument(plaintext != null, "The password is null", new Object[0]);
        Checks.checkArgument(!plaintext.startsWith(BASE_64_CODER.identifier()), "The password contains the illegal sequence " + BASE_64_CODER.identifier(), new Object[0]);
        try {
            Cipher aes = this.getCipher(1);
            return new String(BASE_64_CODER.encode(aes.doFinal(plaintext.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not encrypt the password.");
        }
    }

    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    public String decrypt(String encryptedText) {
        Checks.checkArgument(encryptedText != null, "The password is null", new Object[0]);
        Checks.checkArgument(encryptedText.startsWith(BASE_64_CODER.identifier()), "The password should be Base64 encoded", new Object[0]);
        try {
            Cipher aes = this.getCipher(2);
            return new String(aes.doFinal(BASE_64_CODER.decode(encryptedText.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not decrypt the password.");
        }
    }

    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    private Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance(this.passwordEncryptionKey.getAlgorithm());
        aes.init(mode, this.passwordEncryptionKey);
        return aes;
    }
}

