/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AbstractRecord;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendRecord
extends AbstractRecord {
    private static Logger log = LoggerFactory.getLogger(AppendRecord.class);
    private static final String DEFAULT_PREFIX = "journal";
    private static final String DEFAULT_EXT = ".tmp";
    private static final int DEFAULT_IN_MEMORY_SIZE = 1024;
    private static final int MAXIMUM_IN_MEMORY_SIZE = 65536;
    private final AbstractJournal journal;
    private final String producerId;
    private long revision;
    private DataOutputStream dataOut;
    private ByteArrayOutputStream byteOut;
    private File file;
    private FileOutputStream fileOut;
    private boolean outputClosed;

    public AppendRecord(AbstractJournal journal, String producerId) {
        super(journal.getResolver(), journal.getNamePathResolver());
        this.journal = journal;
        this.producerId = producerId;
        this.revision = 0L;
        this.byteOut = new ByteArrayOutputStream(1024);
        this.dataOut = new DataOutputStream(this.byteOut);
    }

    @Override
    public String getJournalId() {
        return this.journal.getId();
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    @Override
    public void writeByte(int n) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.writeByte(n);
        }
        catch (IOException e) {
            String msg = "I/O error while writing byte.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeChar(char c) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.writeChar(c);
        }
        catch (IOException e) {
            String msg = "I/O error while writing character.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeBoolean(boolean b) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.writeBoolean(b);
        }
        catch (IOException e) {
            String msg = "I/O error while writing boolean.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeInt(int n) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.writeInt(n);
        }
        catch (IOException e) {
            String msg = "I/O error while writing integer.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeLong(long n) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.writeLong(n);
        }
        catch (IOException e) {
            String msg = "I/O error while writing long.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeString(String s) throws JournalException {
        this.checkOutput();
        try {
            if (s == null) {
                this.dataOut.writeBoolean(true);
            } else {
                this.dataOut.writeBoolean(false);
                this.dataOut.writeUTF(s);
            }
        }
        catch (IOException e) {
            String msg = "I/O error while writing string.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void write(byte[] b) throws JournalException {
        this.checkOutput();
        try {
            this.dataOut.write(b);
        }
        catch (IOException e) {
            String msg = "I/O error while writing a byte array.";
            throw new JournalException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long update() throws JournalException {
        boolean succeeded = false;
        try {
            long l;
            int length = this.dataOut.size();
            this.closeOutput();
            InputStream in = this.openInput();
            try {
                this.journal.append(this, in, length);
                succeeded = true;
                l = length;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    String msg = "I/O error while closing stream.";
                    log.warn(msg, (Throwable)e);
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                String msg = "I/O error while closing stream.";
                log.warn(msg, (Throwable)e);
            }
            return l;
        }
        finally {
            this.dispose();
            this.journal.unlock(succeeded);
        }
    }

    @Override
    public void cancelUpdate() {
        if (!this.outputClosed) {
            this.dispose();
            this.journal.unlock(false);
        }
    }

    private InputStream openInput() throws JournalException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                String msg = "Unable to open file input on: " + this.file.getPath();
                throw new JournalException(msg, e);
            }
        }
        return new ByteArrayInputStream(this.byteOut.toByteArray());
    }

    private void checkOutput() throws JournalException {
        if (this.outputClosed) {
            throw new IllegalStateException("Output closed.");
        }
        if (this.fileOut == null && this.byteOut.size() >= 65536) {
            try {
                this.file = File.createTempFile(DEFAULT_PREFIX, DEFAULT_EXT);
            }
            catch (IOException e) {
                String msg = "Unable to create temporary file.";
                throw new JournalException(msg, e);
            }
            try {
                this.fileOut = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                String msg = "Unable to open output stream on: " + this.file.getPath();
                throw new JournalException(msg, e);
            }
            this.dataOut = new DataOutputStream(new BufferedOutputStream(this.fileOut));
            try {
                this.dataOut.write(this.byteOut.toByteArray());
            }
            catch (IOException e) {
                String msg = "Unable to write in-memory record to file.";
                throw new JournalException(msg, e);
            }
        }
    }

    private void closeOutput() throws JournalException {
        if (!this.outputClosed) {
            try {
                if (this.fileOut != null) {
                    this.dataOut.flush();
                    this.fileOut.getFD().sync();
                    this.dataOut.close();
                }
            }
            catch (IOException e) {
                String msg = "I/O error while closing stream.";
                throw new JournalException(msg, e);
            }
            finally {
                this.outputClosed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (!this.outputClosed) {
            try {
                this.dataOut.close();
            }
            catch (IOException e) {
                String msg = "I/O error while closing stream.";
                log.warn(msg, (Throwable)e);
            }
            finally {
                this.outputClosed = true;
            }
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    @Override
    public byte readByte() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public char readChar() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public boolean readBoolean() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public int readInt() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public long readLong() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public String readString() throws JournalException {
        throw this.unsupported();
    }

    @Override
    public void readFully(byte[] b) throws JournalException {
        throw this.unsupported();
    }

    private JournalException unsupported() {
        String msg = "Reading from an appended record is not supported.";
        return new JournalException(msg);
    }
}

